/*
 * Decompiled with CFR 0.152.
 */
class HTCoordE {
    private static final double EPSILON = 1.0E-10;
    double x = 0.0;
    double y = 0.0;

    HTCoordE() {
    }

    HTCoordE(HTCoordE hTCoordE) {
        this.copy(hTCoordE);
    }

    HTCoordE(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    void copy(HTCoordE hTCoordE) {
        this.x = hTCoordE.x;
        this.y = hTCoordE.y;
    }

    void projectionStoE(int n, int n2, HTDraw hTDraw) {
        HTCoordS hTCoordS = hTDraw.getSOrigin();
        HTCoordS hTCoordS2 = hTDraw.getSMax();
        this.x = (double)(n - hTCoordS.x) / (double)hTCoordS2.x;
        this.y = -((double)(n2 - hTCoordS.y) / (double)hTCoordS2.y);
    }

    boolean isValid() {
        return this.d2() < 1.0;
    }

    void multiply(HTCoordE hTCoordE) {
        double d = this.x;
        double d2 = this.y;
        this.x = d * hTCoordE.x - d2 * hTCoordE.y;
        this.y = d * hTCoordE.y + d2 * hTCoordE.x;
    }

    void divide(HTCoordE hTCoordE) {
        double d = hTCoordE.d2();
        double d2 = this.x;
        double d3 = this.y;
        this.x = (d2 * hTCoordE.x + d3 * hTCoordE.y) / d;
        this.y = (d3 * hTCoordE.x - d2 * hTCoordE.y) / d;
    }

    void sub(HTCoordE hTCoordE, HTCoordE hTCoordE2) {
        this.x = hTCoordE.x - hTCoordE2.x;
        this.y = hTCoordE.y - hTCoordE2.y;
    }

    double arg() {
        double d = Math.atan(this.y / this.x);
        if (this.x < 0.0) {
            d += Math.PI;
        } else if (this.y < 0.0) {
            d += Math.PI * 2;
        }
        return d;
    }

    double d2() {
        return this.x * this.x + this.y * this.y;
    }

    double d() {
        return Math.sqrt(this.d2());
    }

    double d(HTCoordE hTCoordE) {
        return Math.sqrt((hTCoordE.x - this.x) * (hTCoordE.x - this.x) + (hTCoordE.y - this.y) * (hTCoordE.y - this.y));
    }

    void translate(HTCoordE hTCoordE) {
        double d = this.x * hTCoordE.x + this.y * hTCoordE.y + 1.0;
        double d2 = this.y * hTCoordE.x - this.x * hTCoordE.y;
        double d3 = d * d + d2 * d2;
        double d4 = this.x + hTCoordE.x;
        double d5 = this.y + hTCoordE.y;
        this.x = (d4 * d + d5 * d2) / d3;
        this.y = (d5 * d - d4 * d2) / d3;
    }

    void translate(HTCoordE hTCoordE, HTCoordE hTCoordE2) {
        this.copy(hTCoordE);
        this.translate(hTCoordE2);
    }

    void transform(HTTransformation hTTransformation) {
        HTCoordE hTCoordE = new HTCoordE(this);
        this.multiply(hTTransformation.O);
        this.x += hTTransformation.P.x;
        this.y += hTTransformation.P.y;
        HTCoordE hTCoordE2 = new HTCoordE(hTTransformation.P);
        hTCoordE2.y = -hTCoordE2.y;
        hTCoordE2.multiply(hTCoordE);
        hTCoordE2.multiply(hTTransformation.O);
        hTCoordE2.x += 1.0;
        this.divide(hTCoordE2);
    }

    public String toString() {
        return "(" + this.x + " : " + this.y + ")E";
    }
}

