/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.image.BufferedImage;

public class HTDoubleBuffer
extends Panel {
    private int bufferWidth;
    private int bufferHeight;
    private Image bufferImage;
    private Graphics bufferGraphics;

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public Color getPixelColor(int n, int n2) {
        return new Color(((BufferedImage)this.bufferImage).getRGB(n, n2));
    }

    public void paint(Graphics graphics) {
        if (this.bufferWidth != this.getSize().width || this.bufferHeight != this.getSize().height || this.bufferImage == null || this.bufferGraphics == null) {
            this.resetBuffer();
        }
        if (this.bufferGraphics != null) {
            this.bufferGraphics.clearRect(0, 0, this.bufferWidth, this.bufferHeight);
            this.paintBuffer(this.bufferGraphics);
            graphics.drawImage(this.bufferImage, 0, 0, this);
            this.bufferImage.flush();
        }
    }

    private void resetBuffer() {
        this.bufferWidth = this.getSize().width;
        this.bufferHeight = this.getSize().height;
        if (this.bufferGraphics != null) {
            this.bufferGraphics.dispose();
            this.bufferGraphics = null;
        }
        if (this.bufferImage != null) {
            this.bufferImage.flush();
            this.bufferImage = null;
        }
        System.gc();
        this.bufferImage = this.createImage(this.bufferWidth, this.bufferHeight);
        this.bufferGraphics = this.bufferImage.getGraphics();
    }

    public void paintBuffer(Graphics graphics) {
    }
}

