/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;

class HTDraw {
    private static final int NBR_FRAMES = 10;
    private HTModel model = null;
    private HTView view = null;
    private HTDrawNode drawRoot = null;
    private HTCoordS sOrigin = null;
    private HTCoordS sMax = null;
    private double[] ray = null;
    private boolean fastMode = false;
    private static int fh;
    private static int fa;
    private static int fl;
    private static int charWidth;
    private static FontMetrics fm;
    public Font mainFont;
    private static boolean first;

    HTDraw(HTModel hTModel, HTView hTView) {
        this.view = hTView;
        this.model = hTModel;
        HTModelNode hTModelNode = hTModel.getRoot();
        this.sOrigin = new HTCoordS();
        this.sMax = new HTCoordS();
        this.ray = new double[4];
        this.ray[0] = hTModel.getLength();
        for (int i = 1; i < this.ray.length; ++i) {
            this.ray[i] = (this.ray[0] + this.ray[i - 1]) / (1.0 + this.ray[0] * this.ray[i - 1]);
        }
        this.drawRoot = hTModelNode.isLeaf() ? new HTDrawNode(null, hTModelNode, this) : new HTDrawNodeComposite(null, (HTModelNodeComposite)hTModelNode, this);
    }

    void refreshScreenCoordinates() {
        Insets insets = this.view.getInsets();
        this.sMax.x = (this.view.getSize().width - insets.left - insets.right) / 2;
        this.sMax.y = (this.view.getSize().height - insets.top - insets.bottom) / 2;
        this.sOrigin.x = this.sMax.x + insets.left;
        this.sOrigin.y = this.sMax.y + insets.top;
        this.drawRoot.refreshScreenCoordinates(this.sOrigin, this.sMax);
    }

    HTCoordS getSOrigin() {
        return this.sOrigin;
    }

    HTCoordS getSMax() {
        return this.sMax;
    }

    void drawBranches(Graphics graphics) {
        this.drawRoot.drawBranches(graphics);
    }

    void drawNodes(Graphics graphics) {
        this.mainFont = new Font(this.view.getFontNode(), 0, this.view.getFontSizeNode());
        graphics.setFont(this.mainFont);
        fm = graphics.getFontMetrics();
        fh = fm.getHeight();
        fa = fm.getAscent();
        fl = fm.getLeading();
        String string = "a";
        char[] cArray = string.toCharArray();
        charWidth = fm.charsWidth(cArray, 0, 1);
        first = true;
        graphics.setColor(new Color(Color.decode(this.getLinkColor()).getRGB()));
        graphics.drawString("Busca:", 15, 14);
        if (this.view.nGraphLines() > 0) {
            if (this.view.getViewLineGraph()) {
                graphics.setColor(new Color(Color.decode(this.getLinkColor()).getRGB()));
                graphics.fillRect(15, 50, 12, 12);
            } else {
                graphics.setColor(new Color(Color.decode(this.getBackColor()).getRGB()));
                graphics.fillRect(15, 50, 12, 12);
                graphics.setColor(new Color(Color.decode(this.getLinkColor()).getRGB()));
                graphics.drawRect(15, 50, 12, 12);
            }
            graphics.drawString("Mostrar linhas de grafo", 32, 62);
            int n = 15;
            int n2 = 66;
            for (int i = 0; i < this.view.graphNames.size(); ++i) {
                if (this.view.getGraphShowI(i)) {
                    graphics.setColor(new Color(Color.decode(this.view.getGraphColorI(i)).getRGB()));
                    graphics.fillRect(n, n2, 12, 12);
                } else {
                    graphics.setColor(new Color(Color.decode(this.getBackColor()).getRGB()));
                    graphics.fillRect(n, n2, 12, 12);
                    graphics.setColor(new Color(Color.decode(this.getLinkColor()).getRGB()));
                    graphics.drawRect(n, n2, 12, 12);
                }
                graphics.drawString(this.view.getGraphNameI(i), 32, n2 + 12);
                n2 += 16;
            }
        }
        graphics.drawString("Embrapa Inform\u00e1tica Agropecu\u00e1ria", 15, this.view.getHeight() - 10);
        String string2 = this.drawRoot.getNodeClientData();
        this.drawRoot.drawLinesGraph(graphics);
        if (string2.charAt(0) == '1') {
            this.drawRoot.drawNodes0(graphics, true);
            this.drawRoot.drawNodes(graphics, true);
        } else {
            this.drawRoot.drawNodes0(graphics, false);
            this.drawRoot.drawNodes(graphics, false);
        }
    }

    int verifyGraphLine(HTCoordS hTCoordS) {
        int n = this.verifyGraphNamesClick(hTCoordS);
        if (n == 1) {
            return 2;
        }
        int n2 = hTCoordS.x;
        int n3 = hTCoordS.y;
        if (this.view.nGraphLines() > 0) {
            if (n2 >= 15 && n2 <= 27 && n3 >= 50 && n3 <= 62) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    int verifyGraphNamesClick(HTCoordS hTCoordS) {
        int n = hTCoordS.x;
        int n2 = hTCoordS.y;
        if (this.view.nGraphLines() > 0) {
            int n3 = 15;
            int n4 = 66;
            for (int i = 0; i < this.view.graphNames.size(); ++i) {
                if (n >= n3 && n <= n3 + 12 && n2 >= n4 && n2 <= n4 + 12) {
                    if (this.view.getGraphShowI(i)) {
                        this.view.setGraphShowI(i, false);
                    } else {
                        this.view.setGraphShowI(i, true);
                    }
                    return 1;
                }
                n4 += 16;
            }
        }
        return 0;
    }

    int verifyHomeClick(HTCoordS hTCoordS) {
        int n = hTCoordS.x;
        int n2 = hTCoordS.y;
        Rectangle rectangle = this.view.getHomeRect();
        if (rectangle == null) {
            return 0;
        }
        if (n >= rectangle.x && n <= rectangle.x + rectangle.width && n2 >= rectangle.y && n2 <= rectangle.y + rectangle.height) {
            this.translateToRootOrigin();
            return 0;
        }
        if (this.view.getCenterNode() != null && n >= rectangle.x + rectangle.width && n <= rectangle.x + rectangle.width + rectangle.width && n2 >= rectangle.y && n2 <= rectangle.y + rectangle.height) {
            HTDrawNode hTDrawNode = this.findNode(this.view.getCenterNode().toLowerCase());
            if (hTDrawNode != null) {
                this.translateToOrigin(hTDrawNode);
            }
            return 0;
        }
        if (n >= rectangle.width + rectangle.x * 3 && n <= rectangle.width + rectangle.x * 3 + rectangle.width && n2 >= rectangle.y && n2 <= rectangle.y + rectangle.height) {
            return 1;
        }
        return 0;
    }

    void drawHint(Graphics graphics) {
        this.drawRoot.drawHint(graphics);
    }

    void translate(HTCoordE hTCoordE, HTCoordE hTCoordE2) {
        HTCoordE hTCoordE3 = new HTCoordE(this.drawRoot.getOldCoordinates());
        hTCoordE3.x = -hTCoordE3.x;
        hTCoordE3.y = -hTCoordE3.y;
        HTCoordE hTCoordE4 = new HTCoordE(hTCoordE);
        hTCoordE4.translate(hTCoordE3);
        HTCoordE hTCoordE5 = new HTCoordE();
        double d = hTCoordE2.d2();
        double d2 = hTCoordE4.d2();
        double d3 = 1.0 - d * d2;
        hTCoordE5.x = (hTCoordE2.x * (1.0 - d2) - hTCoordE4.x * (1.0 - d)) / d3;
        hTCoordE5.y = (hTCoordE2.y * (1.0 - d2) - hTCoordE4.y * (1.0 - d)) / d3;
        if (hTCoordE5.isValid()) {
            HTTransformation hTTransformation = new HTTransformation();
            hTTransformation.composition(hTCoordE3, hTCoordE5);
            this.drawRoot.transform(hTTransformation);
            this.view.repaint();
        }
    }

    void endTranslation() {
        this.drawRoot.endTranslation();
    }

    void translateToOrigin(HTDrawNode hTDrawNode) {
        this.view.stopMouseListening();
        AnimThread animThread = new AnimThread(hTDrawNode);
        animThread.start();
    }

    void translateToRootOrigin() {
        this.view.stopMouseListening();
        AnimThread animThread = new AnimThread(this.drawRoot);
        animThread.start();
    }

    void restore() {
        this.drawRoot.restore();
        this.view.repaint();
    }

    void reDraw() {
        this.view.repaint();
    }

    int getWidthPanel() {
        return this.view.getSize().width;
    }

    int getHeightPanel() {
        return this.view.getSize().height;
    }

    void setHint(boolean bl) {
        this.view.setHasHint(bl);
    }

    String getHelpFile() {
        return this.view.getHelpFile();
    }

    String getUrlAdr() {
        return this.view.getUrlAdr();
    }

    boolean getSearchType() {
        return this.view.getSearchType();
    }

    boolean getIsSearch() {
        return this.view.getIsSearch();
    }

    String getOpenWindow() {
        return this.view.getOpenWindow();
    }

    void fastMode(boolean bl) {
        if (bl != this.fastMode) {
            this.fastMode = bl;
            this.drawRoot.fastMode(bl);
            if (!bl) {
                this.view.repaint();
            }
        }
    }

    int verifyFolder(HTCoordS hTCoordS) {
        return this.drawRoot.verifyFolder(hTCoordS);
    }

    HTDrawNode findNode(HTCoordS hTCoordS) {
        return this.drawRoot.findNode(hTCoordS);
    }

    boolean getClickOnImage() {
        return this.drawRoot.getClickOnImage();
    }

    HTDrawNode findNode(String string) {
        return this.drawRoot.findNode(string);
    }

    String getHintColor() {
        return this.view.getHintColor();
    }

    String getBackColor() {
        return this.view.getBackColor();
    }

    int getBackRed() {
        return this.view.getBackRed();
    }

    int getBackGreen() {
        return this.view.getBackGreen();
    }

    int getBackBlue() {
        return this.view.getBackBlue();
    }

    boolean getHasFolder() {
        return this.view.getHasFolder();
    }

    String getLeafNode() {
        return this.view.getLeafNode();
    }

    String getParentNode() {
        return this.view.getParentNode();
    }

    String getFontNode() {
        return this.view.getFontNode();
    }

    int getFontSizeNode() {
        return this.view.getFontSizeNode();
    }

    String getBorderType() {
        return this.view.getBorderType();
    }

    String getSearchWord() {
        return this.view.getSearchWord();
    }

    String getLinkColor() {
        return this.view.getLinkColor();
    }

    String getSearchColor() {
        return this.view.getSearchColor();
    }

    int getCharWidth() {
        return charWidth;
    }

    int getCharHeight() {
        return fh;
    }

    int getAscent() {
        return fa;
    }

    int getLeading() {
        return fl;
    }

    int getStringWidth(char[] cArray, int n, int n2) {
        if (fm == null) {
            return 0;
        }
        if (new String(cArray) == null) {
            return 0;
        }
        return fm.charsWidth(cArray, n, n2);
    }

    int getStringWidth(String string) {
        if (fm == null) {
            return 0;
        }
        if (string == null) {
            return 0;
        }
        return fm.stringWidth(string);
    }

    int getNumAnds() {
        return this.view.getNumAnds();
    }

    String getWordI(int n) {
        return this.view.getWordI(n);
    }

    void executaSearchWord(String string) {
        this.view.executaSearchWord(string);
    }

    String getLabelCount() {
        return this.view.getLabelCount();
    }

    String getSumTags() {
        return this.view.getSumTags();
    }

    Color getPixelColor(int n, int n2) {
        return this.view.getPixelColor(n, n2);
    }

    public int getIndicePoligono() {
        return this.model.getIndicePoligono();
    }

    public Polygon getPoligono(int n, int n2, int n3, int n4) {
        return this.view.getPoligono(n, n2, n3, n4);
    }

    public int getRectx(int n, int n2, int n3) {
        return this.view.getRectx(n, n2, n3);
    }

    public int getRecty(int n, int n2, int n3) {
        return this.view.getRecty(n, n2, n3);
    }

    int getWidth(int n, int n2) {
        return this.view.getWidth(n, n2);
    }

    int getHeight(int n, int n2) {
        return this.view.getHeight(n, n2);
    }

    public boolean getArqAberto() {
        return this.view.getArqAberto();
    }

    String getName() {
        return this.view.getName();
    }

    int nGraphLines() {
        return this.view.nGraphLines();
    }

    Point getGraphNode1(int n) {
        return this.view.getGraphNode1(n);
    }

    Point getGraphNode2(int n) {
        return this.view.getGraphNode2(n);
    }

    String getArcName(int n) {
        return this.view.getArcName(n);
    }

    public void setViewLineGraph() {
        this.view.setViewLineGraph();
    }

    public boolean getViewLineGraph() {
        return this.view.getViewLineGraph();
    }

    String getGraphColor() {
        return this.view.getGraphColor();
    }

    void folderFechadoGraphLine(HTDrawNode hTDrawNode) {
        this.view.folderFechadoGraphLine(hTDrawNode);
    }

    public boolean mostraGraph(int n) {
        return this.view.mostraGraph(n);
    }

    public boolean showGroup(int n) {
        return this.view.getShowGroup(n);
    }

    public String getGroupColor(int n) {
        return this.view.getGroupColor(n);
    }

    public boolean getDirecionado(int n) {
        return this.view.getDirecionado(n);
    }

    public String getGraphNodeClientData(int n, int n2) {
        return this.view.getGraphNodeClientData(n, n2);
    }

    public boolean getGraphHasData(int n, int n2) {
        return this.view.getGraphHasData(n, n2);
    }

    public void setHasArc(int n, int n2, boolean bl) {
        this.view.setHasArc(n, n2, bl);
    }

    static {
        first = false;
    }

    class AnimThread
    extends Thread {
        private HTDrawNode node = null;
        private Runnable tTask = null;

        AnimThread(HTDrawNode hTDrawNode) {
            this.node = hTDrawNode;
        }

        public void run() {
            HTCoordE hTCoordE = this.node.getOldCoordinates();
            HTCoordE hTCoordE2 = new HTCoordE();
            int n = 10;
            int n2 = HTDraw.this.model.getNumberOfNodes();
            double d = hTCoordE.d();
            for (int i = 0; i < HTDraw.this.ray.length; ++i) {
                if (!(d > HTDraw.this.ray[i])) continue;
                n += 5;
            }
            double d2 = hTCoordE.x / (double)n;
            double d3 = hTCoordE.y / (double)n;
            for (int i = 1; i < n; ++i) {
                hTCoordE2.x = hTCoordE.x - (double)i * d2;
                hTCoordE2.y = hTCoordE.y - (double)i * d3;
                this.tTask = new TranslateThread(hTCoordE, hTCoordE2);
                try {
                    AnimThread.sleep(10L);
                    this.tTask.run();
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            hTCoordE2.x = 0.0;
            hTCoordE2.y = 0.0;
            this.tTask = new LastTranslateThread(hTCoordE, hTCoordE2);
            try {
                AnimThread.sleep(25L);
                this.tTask.run();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        class LastTranslateThread
        implements Runnable {
            HTCoordE zStart = null;
            HTCoordE zEnd = null;

            LastTranslateThread(HTCoordE hTCoordE, HTCoordE hTCoordE2) {
                this.zStart = hTCoordE;
                this.zEnd = hTCoordE2;
            }

            public void run() {
                HTDraw.this.translate(this.zStart, this.zEnd);
                HTDraw.this.endTranslation();
                HTDraw.this.view.repaint();
                HTDraw.this.view.startMouseListening();
            }
        }

        class TranslateThread
        implements Runnable {
            HTCoordE zStart = null;
            HTCoordE zEnd = null;

            TranslateThread(HTCoordE hTCoordE, HTCoordE hTCoordE2) {
                this.zStart = hTCoordE;
                this.zEnd = hTCoordE2;
            }

            public void run() {
                HTDraw.this.translate(this.zStart, this.zEnd);
                HTDraw.this.view.repaint();
            }
        }
    }
}

