/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.image.BufferedImage;
import java.util.Enumeration;

class HTDrawNode {
    private HTDraw model = null;
    private HTModelNode node = null;
    private HTCoordE ze = null;
    private HTCoordE oldZe = null;
    protected HTCoordS zs = null;
    private HTDrawNodeComposite father = null;
    private HTDrawNode brother = null;
    private HTNodeLabel label = null;
    protected boolean fastMode = false;

    HTDrawNode isFatherClose(HTDrawNode hTDrawNode) {
        if (hTDrawNode == null) {
            return null;
        }
        if (hTDrawNode.getHasFolder()) {
            return hTDrawNode;
        }
        HTDrawNode hTDrawNode2 = hTDrawNode.getFather();
        if (hTDrawNode2 == null) {
            return null;
        }
        return this.isFatherClose(hTDrawNode2);
    }

    HTDrawNode(HTDrawNodeComposite hTDrawNodeComposite, HTModelNode hTModelNode, HTDraw hTDraw) {
        this.father = hTDrawNodeComposite;
        this.node = hTModelNode;
        this.model = hTDraw;
        this.label = new HTNodeLabel(this);
        this.ze = new HTCoordE(hTModelNode.getCoordinates());
        this.oldZe = new HTCoordE(this.ze);
        this.zs = new HTCoordS();
    }

    public HTNode getNode() {
        return this.node.getHTNode();
    }

    void setBrother(HTDrawNode hTDrawNode) {
        this.brother = hTDrawNode;
    }

    String getBorderType() {
        return this.model.getBorderType();
    }

    String getHintColor() {
        return this.model.getHintColor();
    }

    String getBackColor() {
        return this.model.getBackColor();
    }

    int getBackRed() {
        return this.model.getBackRed();
    }

    int getBackGreen() {
        return this.model.getBackGreen();
    }

    int getBackBlue() {
        return this.model.getBackBlue();
    }

    boolean getHasFolder() {
        return this.model.getHasFolder();
    }

    String getLeafNode() {
        return this.model.getLeafNode();
    }

    String getParentNode() {
        return this.model.getParentNode();
    }

    String getFontNode() {
        return this.model.getFontNode();
    }

    int getFontSizeNode() {
        return this.model.getFontSizeNode();
    }

    String getSearchColor() {
        return this.model.getSearchColor();
    }

    String getLinkColor() {
        return this.model.getLinkColor();
    }

    String getSearchWord() {
        return this.model.getSearchWord();
    }

    String getHelpFile() {
        return this.model.getHelpFile();
    }

    String getUrlAdr() {
        return this.model.getUrlAdr();
    }

    public Enumeration childrenNode() {
        return this.node.childrenNode();
    }

    String getName() {
        return this.node.getName();
    }

    String getNameArest() {
        return this.node.getNameArest();
    }

    String getColor() {
        return this.node.getColor();
    }

    String getTextColor() {
        return this.node.getTextColor();
    }

    String getURL() {
        return this.node.getURL();
    }

    String getID() {
        return this.node.getID();
    }

    boolean getEspecialMark() {
        return this.node.getEspecialMark();
    }

    public String getHint() {
        return this.node.getHint();
    }

    public boolean getHasHint() {
        return this.node.getHasHint();
    }

    public boolean getHasHintPai() {
        return this.node.getHasHintPai();
    }

    public boolean isLeafNode() {
        return this.node.isLeafNode();
    }

    public boolean getHasData() {
        return this.node.getHasData();
    }

    public void setHasHint(boolean bl) {
        this.node.setHasHint(bl);
    }

    public void setHasData(boolean bl) {
        this.node.setHasData(bl);
    }

    void setEspecialMark(boolean bl) {
        this.node.setEspecialMark(bl);
    }

    String getNodeClientData() {
        return this.node.getNodeClientData();
    }

    public void setNodeClientData(String string) {
        this.node.setNodeClientData(string);
    }

    String getNameImage() {
        return this.node.getNameImage();
    }

    void setHasArc(boolean bl) {
        this.node.setHasArc(bl);
    }

    boolean getHasArc() {
        return this.node.getHasArc();
    }

    HTNodeLabel getHTNodeLabel() {
        return this.label;
    }

    HTDrawNode getBrother() {
        return this.brother;
    }

    int getWidthPanel() {
        return this.model.getWidthPanel();
    }

    int getHeighthPanel() {
        return this.model.getHeightPanel();
    }

    int getAscent() {
        return this.model.getAscent();
    }

    int getLeading() {
        return this.model.getLeading();
    }

    int getCharWidth() {
        return this.model.getCharWidth();
    }

    int getCharHeight() {
        return this.model.getCharHeight();
    }

    int getStringWidth(char[] cArray, int n, int n2) {
        if (cArray == null) {
            return 0;
        }
        return this.model.getStringWidth(cArray, n, n2);
    }

    int getStringWidth(String string) {
        if (string == null) {
            return 0;
        }
        return this.model.getStringWidth(string);
    }

    HTCoordE getCoordinates() {
        return this.ze;
    }

    HTCoordE getOldCoordinates() {
        return this.oldZe;
    }

    HTCoordS getScreenCoordinates() {
        return this.zs;
    }

    HTCoordS getScreenCoordinatesFather() {
        if (this.father == null) {
            return null;
        }
        return this.father.getScreenCoordinates();
    }

    void refreshScreenCoordinates(HTCoordS hTCoordS, HTCoordS hTCoordS2) {
        this.zs.projectionEtoS(this.ze, hTCoordS, hTCoordS2);
    }

    void drawBranches(Graphics graphics) {
    }

    void drawNodes(Graphics graphics, boolean bl) {
        this.label.draw(graphics, this.fastMode, bl);
    }

    void drawLinesGraph(Graphics graphics) {
        this.label.drawLinesGraph(graphics, this.fastMode);
    }

    void drawNodes0(Graphics graphics, boolean bl) {
        this.label.draw0(graphics, this.fastMode, bl);
    }

    void drawHint(Graphics graphics) {
        this.label.drawHint(graphics);
    }

    int getSpace() {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        boolean bl = false;
        HTCoordS hTCoordS = null;
        HTCoordS hTCoordS2 = null;
        if (this.father != null) {
            hTCoordS = this.father.getScreenCoordinates();
            n = this.zs.getDistance(hTCoordS);
            n3 = this.zs.getDistanceX(hTCoordS);
        }
        if (this.brother != null) {
            hTCoordS2 = this.brother.getScreenCoordinates();
            n2 = this.zs.getDistance(hTCoordS2);
            n4 = this.zs.getDistanceY(hTCoordS2);
        }
        if (n == -1 && n2 == -1) {
            return -1;
        }
        if (n == -1) {
            return n2;
        }
        if (n2 == -1) {
            return n;
        }
        int n5 = Math.min(n, n2);
        if (n5 <= this.model.getCharHeight() + 1) {
            return n5;
        }
        if (n3 > n4 && n4 > this.model.getCharHeight() + 1) {
            if (Math.abs(this.zs.x - hTCoordS.x) < n / 2 || Math.abs(this.zs.x - hTCoordS2.x) < n && Math.abs(this.zs.y - hTCoordS2.y) < this.model.getCharHeight()) {
                return n5;
            }
            if (this.isLeafNode()) {
                return (n + n2) / 2;
            }
            return n;
        }
        return n5;
    }

    void translate(HTCoordE hTCoordE) {
        this.ze.translate(this.oldZe, hTCoordE);
    }

    void transform(HTTransformation hTTransformation) {
        this.ze.copy(this.oldZe);
        this.ze.transform(hTTransformation);
    }

    void endTranslation() {
        this.oldZe.copy(this.ze);
    }

    void restore() {
        HTCoordE hTCoordE = this.node.getCoordinates();
        this.ze.x = hTCoordE.x;
        this.ze.y = hTCoordE.y;
        this.oldZe.copy(this.ze);
    }

    void fastMode(boolean bl) {
        if (bl != this.fastMode) {
            this.fastMode = bl;
        }
    }

    HTDrawNode findNode(HTCoordS hTCoordS) {
        if (this.label.contains(hTCoordS)) {
            return this;
        }
        return null;
    }

    boolean getClickOnImage() {
        return this.label.getClickOnImage();
    }

    HTDrawNode findNode(String string) {
        if (this.getID().equals(string)) {
            this.setEspecialMark(true);
            return this;
        }
        return null;
    }

    int verifyFolder(HTCoordS hTCoordS) {
        return this.label.verifyFolder(hTCoordS);
    }

    public String toString() {
        String string = this.getName() + "\n\t" + this.ze + "\n\t" + this.zs;
        return string;
    }

    int getNumAnds() {
        return this.model.getNumAnds();
    }

    String getWordI(int n) {
        return this.model.getWordI(n);
    }

    boolean getSearchType() {
        return this.model.getSearchType();
    }

    boolean getIsSearch() {
        return this.model.getIsSearch();
    }

    String getLabelCount() {
        return this.model.getLabelCount();
    }

    String getSumTags() {
        return this.model.getSumTags();
    }

    public BufferedImage getImage() {
        return this.node.getImage();
    }

    Color getPixelColor(int n, int n2) {
        return this.model.getPixelColor(n, n2);
    }

    void setNodeClientStatus(String string) {
        this.node.setNodeClientStatus(string);
    }

    public int getIndicePoligono() {
        return this.node.getIndicePoligono();
    }

    public Polygon getPoligono(int n, int n2, int n3, int n4) {
        return this.model.getPoligono(n, n2, n3, n4);
    }

    public int getRectx(int n, int n2, int n3) {
        return this.model.getRectx(n, n2, n3);
    }

    public int getRecty(int n, int n2, int n3) {
        return this.model.getRecty(n, n2, n3);
    }

    public int getWidth(int n, int n2) {
        return this.model.getWidth(n, n2);
    }

    public int getHeight(int n, int n2) {
        return this.model.getHeight(n, n2);
    }

    public boolean getArqAberto() {
        return this.model.getArqAberto();
    }

    HTDrawNode getFather() {
        return this.father;
    }

    int nGraphLines() {
        return this.model.nGraphLines();
    }

    Point getGraphNode1(int n) {
        return this.model.getGraphNode1(n);
    }

    Point getGraphNode2(int n) {
        return this.model.getGraphNode2(n);
    }

    public void saveXY(int n, int n2) {
        this.node.saveXY(n, n2);
    }

    public int getSavedX() {
        return this.node.getSavedX();
    }

    public int getSavedY() {
        return this.node.getSavedY();
    }

    String getGraphColor() {
        return this.model.getGraphColor();
    }

    public boolean getViewLineGraph() {
        return this.model.getViewLineGraph();
    }

    public String getArcName(int n) {
        return this.model.getArcName(n);
    }

    public boolean mostraGraph(int n) {
        return this.model.mostraGraph(n);
    }

    public boolean showGroup(int n) {
        return this.model.showGroup(n);
    }

    public String getGroupColor(int n) {
        return this.model.getGroupColor(n);
    }

    public boolean getDirecionado(int n) {
        return this.model.getDirecionado(n);
    }

    public String getGraphNodeClientData(int n, int n2) {
        return this.model.getGraphNodeClientData(n, n2);
    }

    public boolean getGraphHasData(int n, int n2) {
        return this.model.getGraphHasData(n, n2);
    }

    public void setHasArc(int n, int n2, boolean bl) {
        this.model.setHasArc(n, n2, bl);
    }
}

