/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class HTFileNode
implements HTNode,
Serializable {
    String id;
    String name;
    String hint;
    String color;
    String URL;
    String textColor;
    String nameArest;
    boolean especialMark;
    String nodeClientData;
    boolean leafNode;
    boolean hasHint;
    boolean hasData;
    boolean hasArc;
    int[] pixels;
    transient BufferedImage imageN;
    int imageW;
    int imageH;
    String nameImage;
    private Hashtable children = new Hashtable();
    int poligono;
    int x;
    int y;

    public HTFileNode() {
        this.id = "";
        this.name = "";
        this.nameArest = "";
        this.hint = "";
        this.color = "";
        this.URL = "";
        this.textColor = "";
        this.especialMark = false;
        this.nodeClientData = "";
        this.leafNode = true;
        this.hasHint = false;
        this.hasData = false;
        this.hasArc = false;
        this.imageN = null;
        this.nameImage = "";
        this.pixels = null;
        this.poligono = 0;
    }

    public HTFileNode(HTFileNode hTFileNode) {
        this.id = hTFileNode.getID();
        this.name = hTFileNode.getName();
        this.nameArest = hTFileNode.getNameArest();
        this.hint = hTFileNode.getHint();
        this.color = hTFileNode.getColor();
        this.URL = hTFileNode.getURL();
        this.textColor = hTFileNode.getTextColor();
        this.especialMark = false;
        this.nodeClientData = hTFileNode.getNodeClientData();
        this.poligono = hTFileNode.getIndicePoligono();
        this.leafNode = hTFileNode.isLeafNode();
        this.hasHint = false;
        this.hasData = false;
        this.hasArc = false;
        try {
            if (hTFileNode.getImage() != null) {
                this.nameImage = hTFileNode.getNameImage();
                this.imageW = hTFileNode.getImageW();
                this.imageH = hTFileNode.getImageH();
                this.pixels = this.getArrayFromImage(hTFileNode.getImage(), this.imageW, this.imageH);
                this.setImageFromPixels();
            } else {
                this.imageN = null;
                this.nameImage = "";
                this.pixels = null;
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    private int getImageW() {
        return this.imageW;
    }

    private int getImageH() {
        return this.imageH;
    }

    protected void addChild(HTFileNode hTFileNode) {
        this.children.put(hTFileNode.getID(), hTFileNode);
    }

    protected void removeChild(String string) {
        this.children.remove(string);
    }

    public Enumeration children() {
        return this.children.elements();
    }

    public Enumeration childrenNode() {
        return this.children.elements();
    }

    public boolean isLeaf() {
        return this.leafNode;
    }

    public boolean isLeafNode() {
        return this.leafNode;
    }

    public void setLeafNode(boolean bl) {
        this.leafNode = bl;
    }

    public void setNodeClientStatus(String string) {
        HTFileNode hTFileNode = null;
        Enumeration enumeration = this.childrenNode();
        while (enumeration.hasMoreElements()) {
            hTFileNode = (HTFileNode)enumeration.nextElement();
            if (hTFileNode.isLeafNode()) continue;
            hTFileNode.setNodeClientData(string);
            hTFileNode.setNodeClientStatus(string);
        }
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getNameArest() {
        return this.nameArest;
    }

    public String getHint() {
        return this.hint;
    }

    public String getURL() {
        return this.URL;
    }

    public String getColor() {
        return this.color;
    }

    public boolean getEspecialMark() {
        return this.especialMark;
    }

    public String getTextColor() {
        return this.textColor;
    }

    public String getNodeClientData() {
        if (this.nodeClientData == null || this.nodeClientData.length() == 0) {
            return "11";
        }
        return this.nodeClientData;
    }

    public boolean getHasHint() {
        return this.hasHint;
    }

    public boolean getHasData() {
        return this.hasData;
    }

    public boolean getHasArc() {
        return this.hasArc;
    }

    public int[] getPixels() {
        return this.pixels;
    }

    public BufferedImage getImage() {
        return this.imageN;
    }

    public String getNameImage() {
        return this.nameImage;
    }

    public void setRemoveImage() {
        this.imageN = null;
        this.nameImage = "";
        this.pixels = null;
    }

    public void setNameImage(String string, String string2) {
        this.nameImage = string;
        try {
            double d;
            System.out.println(this.nameImage);
            Image image = Toolkit.getDefaultToolkit().getImage(string2);
            MediaTracker mediaTracker = new MediaTracker(new Container());
            mediaTracker.addImage(image, 0);
            mediaTracker.waitForID(0);
            int n = 100;
            int n2 = 100;
            double d2 = (double)n / (double)n2;
            int n3 = image.getWidth(null);
            int n4 = image.getHeight(null);
            if (n3 < n3) {
                // empty if block
            }
            if (n4 < n2) {
                n2 = n4;
            }
            if (d2 < (d = (double)n3 / (double)n4)) {
                n2 = (int)((double)n / d);
            } else {
                n = (int)((double)n2 * d);
            }
            this.imageN = new BufferedImage(n, n2, 1);
            Graphics2D graphics2D = this.imageN.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            graphics2D.drawImage(image, 0, 0, n, n2, null);
            this.pixels = this.getArrayFromImage(this.imageN, n, n2);
            this.imageW = n;
            this.imageH = n2;
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    private int[] getArrayFromImage(BufferedImage bufferedImage, int n, int n2) throws InterruptedException {
        int[] nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(bufferedImage, 0, 0, n, n2, nArray, 0, n);
        pixelGrabber.grabPixels();
        return nArray;
    }

    private Image getImageFromArray(int[] nArray, int n, int n2) {
        MemoryImageSource memoryImageSource = new MemoryImageSource(n, n2, nArray, 0, n);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        return toolkit.createImage(memoryImageSource);
    }

    void setImageFromPixels() {
        Image image = this.getImageFromArray(this.pixels, this.imageW, this.imageH);
        this.imageN = new BufferedImage(this.imageW, this.imageH, 1);
        Graphics2D graphics2D = this.imageN.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        graphics2D.drawImage(image, 0, 0, this.imageW, this.imageH, null);
    }

    public void setID(String string) {
        this.id = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setNameArest(String string) {
        this.nameArest = string;
    }

    public void setHint(String string) {
        this.hint = string;
    }

    public void setURL(String string) {
        this.URL = string;
    }

    public void setColor(String string) {
        this.color = string;
    }

    public void setEspecialMark(boolean bl) {
        this.especialMark = bl;
    }

    public void setTextColor(String string) {
        this.textColor = string;
    }

    public void setNodeClientData(String string) {
        this.nodeClientData = string;
    }

    public void setHasHint(boolean bl) {
        this.hasHint = bl;
    }

    public void setHasData(boolean bl) {
        this.hasData = bl;
    }

    public void setHasArc(boolean bl) {
        this.hasArc = bl;
    }

    public String editFilho() {
        String string = "";
        if (this.getName().length() > 0) {
            string = "Nome:" + this.getName();
        }
        if (this.getNameArest().length() > 0) {
            string = string + ";NomeAresta:" + this.getNameArest();
        }
        if (this.getColor().length() > 0) {
            string = string + ";Cor:" + this.getColor();
        }
        if (this.getTextColor().length() > 0) {
            string = string + ";Cor_texto:" + this.getTextColor();
        }
        if (this.getHint().length() > 0) {
            string = string + ";Hint:" + this.getHint();
        }
        if (this.getURL().length() > 0) {
            string = string + ";URL:" + this.getURL();
        }
        return string;
    }

    public void saveFilho(String string) {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        int n = string.toLowerCase().indexOf("mudarNome:");
        if (n < 0) {
            int n2;
            n = string.toLowerCase().indexOf("nome:");
            if (n >= 0) {
                for (n2 = n + 5; n2 < string.length() && string.charAt(n2) != ';'; ++n2) {
                    string2 = string2 + string.charAt(n2);
                }
            }
            if ((n = string.toLowerCase().indexOf("nomearesta:")) >= 0) {
                for (n2 = n + 11; n2 < string.length() && string.charAt(n2) != ';'; ++n2) {
                    string3 = string3 + string.charAt(n2);
                }
            }
            if ((n = string.toLowerCase().indexOf("cor:")) >= 0) {
                for (n2 = n + 4; n2 < string.length() && string.charAt(n2) != ';'; ++n2) {
                    string4 = string4 + string.charAt(n2);
                }
            }
            if ((n = string.toLowerCase().indexOf("hint:")) >= 0) {
                for (n2 = n + 5; n2 < string.length() && string.charAt(n2) != ';'; ++n2) {
                    string5 = string5 + string.charAt(n2);
                }
            }
            if ((n = string.toLowerCase().indexOf("url:")) >= 0) {
                for (n2 = n + 4; n2 < string.length() && string.charAt(n2) != ';'; ++n2) {
                    string6 = string6 + string.charAt(n2);
                }
            }
            if ((n = string.toLowerCase().indexOf("cor_texto:")) >= 0) {
                for (n2 = n + 10; n2 < string.length() && string.charAt(n2) != ';'; ++n2) {
                    string7 = string7 + string.charAt(n2);
                }
            }
            this.setName(string2);
            this.setNameArest(string3);
            this.setColor(string4);
            this.setHint(string5);
            this.setURL(string6);
            if (string7.length() >= 8) {
                this.setTextColor(string7);
            }
        }
    }

    public void insereFilho(int n) {
        String string = "0xFFFFFF";
        String string2 = "0x00FF00";
        HTFileNode hTFileNode = new HTFileNode();
        Date date = new Date();
        hTFileNode.setID("_" + date.getTime() + "_F");
        hTFileNode.setColor(this.getColor());
        hTFileNode.setTextColor(this.getTextColor());
        hTFileNode.setName("Filho " + hTFileNode.getID());
        hTFileNode.setLeafNode(true);
        this.setLeafNode(false);
        this.setHasHint(false);
        this.setEspecialMark(false);
        this.addChild(hTFileNode);
    }

    public void deleteFilho(String string) {
        this.removeChild(string);
    }

    public void insereRamo(HTNode hTNode, int n) {
        HTFileNode hTFileNode;
        if (hTNode != null && n > -1) {
            this.insereFromRamo((HTFileNode)hTNode, this, n, true);
        }
        if (hTNode != null && n == -1) {
            hTFileNode = new HTFileNode((HTFileNode)hTNode);
            hTFileNode.setID(hTFileNode.getID() + "_M_" + this.getID());
            hTFileNode = (HTFileNode)hTNode;
            this.addChild(hTFileNode);
            this.setLeafNode(false);
        }
        if (hTNode != null && n == -2) {
            hTFileNode = new HTFileNode((HTFileNode)hTNode);
            hTFileNode.setID(hTFileNode.getID() + "_H_" + this.getID());
            ++n;
            hTFileNode.setHint("Representa um ciclo para o n\u00f3: " + hTFileNode.getName() + " &crlf " + hTFileNode.getHint());
            hTFileNode.setName("  ");
            this.addChild(hTFileNode);
            this.setLeafNode(false);
        }
    }

    public void insereFromRamo(HTFileNode hTFileNode, HTFileNode hTFileNode2, int n, boolean bl) {
        Object object;
        HTFileNode hTFileNode3;
        if (hTFileNode == null || hTFileNode2 == null || hTFileNode2 == hTFileNode) {
            return;
        }
        if (bl) {
            hTFileNode3 = new HTFileNode(hTFileNode);
            object = new Date();
            hTFileNode3.setID("_" + hTFileNode.getID() + "_" + ((Date)object).getTime() + "_F");
            ++n;
            hTFileNode3.setColor(hTFileNode2.getColor());
            hTFileNode2.addChild(hTFileNode3);
        } else {
            hTFileNode3 = hTFileNode2;
        }
        hTFileNode2.setLeafNode(false);
        object = hTFileNode.children();
        while (object.hasMoreElements()) {
            Date date;
            HTFileNode hTFileNode4;
            HTFileNode hTFileNode5 = (HTFileNode)object.nextElement();
            if (!hTFileNode5.isLeaf()) {
                hTFileNode4 = new HTFileNode(hTFileNode5);
                date = new Date();
                hTFileNode4.setID("_" + hTFileNode5.getID() + "_" + date.getTime() + "_F");
                hTFileNode4.setColor(hTFileNode3.getColor());
                hTFileNode3.setLeafNode(false);
                hTFileNode3.addChild(hTFileNode4);
                this.insereFromRamo(hTFileNode5, hTFileNode4, ++n, false);
                continue;
            }
            hTFileNode4 = new HTFileNode(hTFileNode5);
            date = new Date();
            hTFileNode4.setID("_" + hTFileNode5.getID() + "_" + date.getTime() + "_F");
            ++n;
            hTFileNode4.setColor(hTFileNode3.getColor());
            hTFileNode3.setLeafNode(false);
            hTFileNode3.addChild(hTFileNode4);
        }
    }

    public HTNode findPai(String string) {
        return this.buscaPai(this, string);
    }

    public HTFileNode buscaPai(HTFileNode hTFileNode, String string) {
        Enumeration enumeration = hTFileNode.children();
        while (enumeration.hasMoreElements()) {
            HTFileNode hTFileNode2;
            HTFileNode hTFileNode3 = (HTFileNode)enumeration.nextElement();
            if (hTFileNode3.getID().trim().equals(string.trim())) {
                return hTFileNode;
            }
            if (hTFileNode3.isLeaf() || (hTFileNode2 = this.buscaPai(hTFileNode3, string)) == null) continue;
            return hTFileNode2;
        }
        return null;
    }

    public HTNode findRamo(String string) {
        if (string != null) {
            return this.buscaRamo(this, string);
        }
        return null;
    }

    public HTFileNode buscaRamo(HTFileNode hTFileNode, String string) {
        if (hTFileNode == null || string == null) {
            return null;
        }
        Enumeration enumeration = hTFileNode.children();
        while (enumeration.hasMoreElements()) {
            HTFileNode hTFileNode2;
            HTFileNode hTFileNode3 = (HTFileNode)enumeration.nextElement();
            if (hTFileNode3.getID().trim().equals(string.trim())) {
                return hTFileNode3;
            }
            if (hTFileNode3.isLeaf() || (hTFileNode2 = this.buscaRamo(hTFileNode3, string)) == null) continue;
            return hTFileNode2;
        }
        return null;
    }

    public void aplicarCoresFilhos(String string) {
        int n;
        String string2 = "";
        String string3 = "";
        int n2 = string.toLowerCase().indexOf("cor:");
        if (n2 >= 0) {
            for (n = n2 + 4; n < string.length() && string.charAt(n) != ';'; ++n) {
                string2 = string2 + string.charAt(n);
            }
        }
        if ((n2 = string.toLowerCase().indexOf("cor_texto:")) >= 0) {
            for (n = n2 + 10; n < string.length() && string.charAt(n) != ';'; ++n) {
                string3 = string3 + string.charAt(n);
            }
        }
        if (string2.length() > 7) {
            this.setColor(string2);
        }
        if (string3.length() > 7) {
            this.setTextColor(string3);
        }
        this.aplicarCores(this, string2, string3);
    }

    public void aplicarCores(HTFileNode hTFileNode, String string, String string2) {
        if (hTFileNode == null || this.id == null) {
            return;
        }
        Enumeration enumeration = hTFileNode.children();
        while (enumeration.hasMoreElements()) {
            HTFileNode hTFileNode2 = (HTFileNode)enumeration.nextElement();
            if (string.length() > 7) {
                hTFileNode2.setColor(string);
            }
            if (string2.length() > 7) {
                hTFileNode2.setTextColor(string2);
            }
            if (hTFileNode2.isLeaf()) continue;
            this.aplicarCores(hTFileNode2, string, string2);
        }
    }

    public void setIndicePoligono(int n) {
        this.poligono = n;
    }

    public int getIndicePoligono() {
        return this.poligono;
    }

    public void saveXY(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public int getSavedX() {
        return this.x;
    }

    public int getSavedY() {
        return this.y;
    }
}

