/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;

class HTGeodesic {
    private static final double EPSILON = 1.0E-5;
    private static final int LINE = 0;
    private static final int ARC = 1;
    private int type = 0;
    private HTCoordE npoint = null;
    private HTCoordE za = null;
    private HTCoordE zb = null;
    private HTCoordE zc = null;
    private HTCoordE zo = null;
    private HTCoordS a = null;
    private HTCoordS b = null;
    private HTCoordS c = null;
    private int numberSubintervals = 11;
    private int numberHandles = 3;
    private double[] xcoord = new double[this.numberHandles];
    private double[] ycoord = new double[this.numberHandles];
    private double[] yValues = new double[this.numberSubintervals + 1];
    private double[] xValues = new double[this.numberSubintervals + 1];
    private Color color;
    private Color colorNode = Color.blue;
    private double PA;
    private double PB;
    private double PC;

    HTGeodesic(HTCoordE hTCoordE, HTCoordE hTCoordE2) {
        this.za = hTCoordE;
        this.zb = hTCoordE2;
        this.npoint = new HTCoordE();
        this.zc = new HTCoordE();
        this.zo = new HTCoordE();
        this.a = new HTCoordS();
        this.b = new HTCoordS();
        this.c = new HTCoordS();
        this.rebuild();
    }

    void refreshScreenCoordinates(HTCoordS hTCoordS, HTCoordS hTCoordS2) {
        this.a.projectionEtoS(this.za, hTCoordS, hTCoordS2);
        this.b.projectionEtoS(this.zb, hTCoordS, hTCoordS2);
        this.c.projectionEtoS(this.zc, hTCoordS, hTCoordS2);
    }

    void rebuild() {
        if (Math.abs(this.za.d()) < 1.0E-5 || Math.abs(this.zb.d()) < 1.0E-5 || Math.abs(this.za.x / this.zb.x - this.za.y / this.zb.y) < 1.0E-5) {
            this.type = 0;
        } else {
            this.type = 1;
            double d = 1.0 + this.za.x * this.za.x + this.za.y * this.za.y;
            double d2 = 1.0 + this.zb.x * this.zb.x + this.zb.y * this.zb.y;
            double d3 = 2.0 * (this.za.x * this.zb.y - this.zb.x * this.za.y);
            this.zo.x = (this.zb.y * d - this.za.y * d2) / d3;
            this.zo.y = (this.za.x * d2 - this.zb.x * d) / d3;
            double d4 = (this.zb.x - this.zo.x) * (this.za.y - this.zo.y) - (this.za.x - this.zo.x) * (this.zb.y - this.zo.y);
            double d5 = this.za.y * (this.za.y - this.zo.y) - this.za.x * (this.zo.x - this.za.x);
            double d6 = this.zb.y * (this.zb.y - this.zo.y) - this.zb.x * (this.zo.x - this.zb.x);
            this.zc.x = ((this.za.y - this.zo.y) * d6 - (this.zb.y - this.zo.y) * d5) / d4;
            this.zc.y = ((this.zo.x - this.za.x) * d6 - (this.zo.x - this.zb.x) * d5) / d4;
        }
    }

    void draw(Graphics graphics, boolean bl, String string) {
        this.colorNode = new Color(Color.decode(string).getRGB());
        this.type = bl || this.a.getDistance(this.b) < 33 ? 0 : 1;
        switch (this.type) {
            case 0: {
                graphics.drawLine(this.a.x, this.a.y, this.b.x, this.b.y);
                break;
            }
            case 1: {
                this.color = graphics.getColor();
                this.drawCurvedLine(graphics, this.a.x, this.a.y, this.c.x, this.c.y, this.b.x, this.b.y);
                this.drawCurvedLine(graphics, this.a.x, this.a.y, this.c.x + 1, this.c.y, this.b.x + 1, this.b.y);
                this.drawCurvedLine(graphics, this.a.x, this.a.y, this.c.x - 1, this.c.y, this.b.x - 1, this.b.y);
                this.drawCurvedLine(graphics, this.a.x, this.a.y, this.c.x, this.c.y + 1, this.b.x, this.b.y + 1);
                this.drawCurvedLine(graphics, this.a.x, this.a.y, this.c.x, this.c.y - 1, this.b.x, this.b.y - 1);
                this.drawCurvedLine(graphics, this.a.x, this.a.y, this.c.x + 1, this.c.y, this.b.x + 2, this.b.y);
                this.drawCurvedLine(graphics, this.a.x, this.a.y, this.c.x - 1, this.c.y, this.b.x - 2, this.b.y);
                this.drawCurvedLine(graphics, this.a.x, this.a.y, this.c.x, this.c.y + 1, this.b.x, this.b.y + 2);
                this.drawCurvedLine(graphics, this.a.x, this.a.y, this.c.x, this.c.y - 1, this.b.x, this.b.y - 2);
                break;
            }
        }
    }

    void draw(Graphics graphics, boolean bl, boolean bl2, String string) {
        this.colorNode = new Color(Color.decode(string).getRGB());
        this.type = bl2 || this.a.getDistance(this.b) < 33 ? 0 : 1;
        switch (this.type) {
            case 0: {
                if (bl) {
                    graphics.drawLine(this.a.x + 1, this.a.y, this.b.x + 1, this.b.y);
                    graphics.drawLine(this.a.x - 1, this.a.y, this.b.x - 1, this.b.y);
                    graphics.drawLine(this.a.x, this.a.y + 1, this.b.x, this.b.y + 1);
                    graphics.drawLine(this.a.x, this.a.y - 1, this.b.x, this.b.y - 1);
                }
                graphics.drawLine(this.a.x, this.a.y, this.b.x, this.b.y);
                break;
            }
            case 1: {
                if (bl) {
                    this.drawCurvedLine1(graphics, this.a.x + 1, this.a.y, this.c.x + 1, this.c.y, this.b.x + 1, this.b.y);
                    this.drawCurvedLine1(graphics, this.a.x - 1, this.a.y, this.c.x - 1, this.c.y, this.b.x - 1, this.b.y);
                    this.drawCurvedLine1(graphics, this.a.x + 2, this.a.y, this.c.x + 2, this.c.y, this.b.x + 2, this.b.y);
                    this.drawCurvedLine1(graphics, this.a.x - 2, this.a.y, this.c.x - 2, this.c.y, this.b.x - 2, this.b.y);
                    this.drawCurvedLine1(graphics, this.a.x, this.a.y + 1, this.c.x, this.c.y + 1, this.b.x, this.b.y + 1);
                    this.drawCurvedLine1(graphics, this.a.x, this.a.y - 1, this.c.x, this.c.y - 1, this.b.x, this.b.y - 1);
                    this.drawCurvedLine1(graphics, this.a.x, this.a.y + 2, this.c.x, this.c.y + 2, this.b.x, this.b.y + 2);
                    this.drawCurvedLine1(graphics, this.a.x, this.a.y - 2, this.c.x, this.c.y - 2, this.b.x, this.b.y - 2);
                }
                this.drawCurvedLine1(graphics, this.a.x, this.a.y, this.c.x, this.c.y, this.b.x, this.b.y);
                break;
            }
        }
    }

    void drawCurvedLine(Graphics graphics, double d, double d2, double d3, double d4, double d5, double d6) {
        this.setValues(d, d2, d3, d4, d5, d6);
        if (this.computeValues()) {
            this.myDoubleDrawPolygon(graphics);
        } else {
            graphics.drawLine((int)this.xcoord[0], (int)this.ycoord[0], (int)this.xcoord[2], (int)this.ycoord[2]);
        }
    }

    void drawCurvedLine1(Graphics graphics, double d, double d2, double d3, double d4, double d5, double d6) {
        this.setValues(d, d2, d3, d4, d5, d6);
        if (this.computeValues()) {
            this.myDoubleDrawPolygon1(graphics);
        } else {
            graphics.drawLine((int)this.xcoord[0], (int)this.ycoord[0], (int)this.xcoord[2], (int)this.ycoord[2]);
        }
    }

    void setValues(double d, double d2, double d3, double d4, double d5, double d6) {
        this.xcoord[0] = d;
        this.ycoord[0] = d2;
        this.xcoord[1] = d3;
        this.ycoord[1] = d4;
        this.xcoord[2] = d5;
        this.ycoord[2] = d6;
    }

    boolean computeValues2() {
        double d = this.xValues[0];
        double d2 = this.yValues[0];
        double d3 = this.xValues[2];
        double d4 = this.yValues[2];
        double d5 = 1.0 + d * d + d2 * d2;
        double d6 = 1.0 + d3 * d3 + d4 * d4;
        double d7 = 2.0 * (d * d4 - d3 * d2);
        double d8 = (d4 * d5 - d2 * d6) / d7;
        double d9 = (d * d6 - d3 * d5) / d7;
        double d10 = (d3 - d8) * (d2 - d9) - (d - d8) * (d4 - d9);
        double d11 = d2 * (d2 - d9) - d * (d8 - d);
        double d12 = d4 * (d4 - d9) - d3 * (d8 - d3);
        this.xValues[0] = this.xcoord[0];
        this.yValues[0] = this.ycoord[0];
        this.xValues[5] = this.xcoord[1];
        this.yValues[5] = this.ycoord[1];
        this.xValues[this.numberSubintervals - 1] = this.xcoord[2];
        this.yValues[this.numberSubintervals - 1] = this.ycoord[2];
        HTCoordE hTCoordE = this.calcule(this.xValues[0], this.yValues[0], this.xValues[5], this.yValues[5], d8, d9, d12, d11, d10);
        this.xValues[2] = hTCoordE.x;
        this.yValues[2] = hTCoordE.y;
        hTCoordE = this.calcule(this.xValues[5], this.yValues[5], this.xValues[10], this.yValues[10], d8, d9, d12, d11, d10);
        this.xValues[8] = hTCoordE.x;
        this.yValues[8] = hTCoordE.y;
        hTCoordE = this.calcule(this.xValues[0], this.yValues[0], this.xValues[2], this.yValues[2], d8, d9, d12, d11, d10);
        this.xValues[1] = hTCoordE.x;
        this.yValues[1] = hTCoordE.y;
        hTCoordE = this.calcule(this.xValues[8], this.yValues[8], this.xValues[10], this.yValues[10], d8, d9, d12, d11, d10);
        this.xValues[9] = hTCoordE.x;
        this.yValues[9] = hTCoordE.y;
        double d13 = (this.xValues[2] + this.xValues[5]) / 2.0;
        double d14 = (this.yValues[2] + this.yValues[5]) / 2.0;
        double d15 = (this.xValues[5] + this.xValues[8]) / 2.0;
        double d16 = (this.yValues[5] + this.yValues[8]) / 2.0;
        hTCoordE = this.calcule(d13, d14, this.xValues[5], this.yValues[5], d8, d9, d12, d11, d10);
        this.xValues[4] = hTCoordE.x;
        this.yValues[4] = hTCoordE.y;
        hTCoordE = this.calcule(d15, d16, this.xValues[8], this.yValues[8], d8, d9, d12, d11, d10);
        this.xValues[6] = hTCoordE.x;
        this.yValues[6] = hTCoordE.y;
        hTCoordE = this.calcule(this.xValues[2], this.yValues[2], this.xValues[4], this.yValues[4], d8, d9, d12, d11, d10);
        this.xValues[3] = hTCoordE.x;
        this.yValues[3] = hTCoordE.y;
        hTCoordE = this.calcule(this.xValues[6], this.yValues[6], this.xValues[8], this.yValues[8], d8, d9, d12, d11, d10);
        this.xValues[7] = hTCoordE.x;
        this.yValues[7] = hTCoordE.y;
        this.xValues[this.numberSubintervals] = this.xcoord[2];
        this.yValues[this.numberSubintervals] = this.ycoord[2];
        return true;
    }

    boolean computeValues() {
        this.xValues[0] = this.xcoord[0];
        this.yValues[0] = this.ycoord[0];
        this.xValues[5] = this.xcoord[1];
        this.yValues[5] = this.ycoord[1];
        this.xValues[this.numberSubintervals - 1] = this.xcoord[2];
        this.yValues[this.numberSubintervals - 1] = this.ycoord[2];
        this.xValues[2] = (this.xValues[0] + this.xValues[5]) / 2.0;
        this.yValues[2] = (this.yValues[0] + this.yValues[5]) / 2.0;
        this.xValues[8] = (this.xValues[5] + this.xValues[10]) / 2.0;
        this.yValues[8] = (this.yValues[5] + this.yValues[10]) / 2.0;
        this.xValues[1] = (this.xValues[0] + this.xValues[2]) / 2.0;
        this.yValues[1] = (this.yValues[0] + this.yValues[2]) / 2.0;
        this.xValues[9] = (this.xValues[8] + this.xValues[10]) / 2.0;
        this.yValues[9] = (this.yValues[8] + this.yValues[10]) / 2.0;
        double d = (this.xValues[2] + this.xValues[5]) / 2.0;
        double d2 = (this.yValues[2] + this.yValues[5]) / 2.0;
        double d3 = (this.xValues[5] + this.xValues[8]) / 2.0;
        double d4 = (this.yValues[5] + this.yValues[8]) / 2.0;
        this.xValues[4] = (d + this.xValues[5]) / 2.0;
        this.yValues[4] = (d2 + this.yValues[5]) / 2.0;
        this.xValues[6] = (d3 + this.xValues[5]) / 2.0;
        this.yValues[6] = (d4 + this.yValues[5]) / 2.0;
        this.suavizaCentro1();
        this.suavizaCentro1();
        this.suavizaCentro1();
        this.suavizaTotal();
        this.suavizaTotal();
        this.suavizaTotal();
        this.xValues[this.numberSubintervals] = this.xcoord[2];
        this.yValues[this.numberSubintervals] = this.ycoord[2];
        return true;
    }

    void suavizaCentro1() {
        this.xValues[3] = (this.xValues[2] + this.xValues[4]) / 2.0;
        this.yValues[3] = (this.yValues[2] + this.yValues[4]) / 2.0;
        this.xValues[7] = (this.xValues[6] + this.xValues[8]) / 2.0;
        this.yValues[7] = (this.yValues[6] + this.yValues[8]) / 2.0;
        this.xValues[5] = (this.xValues[4] + this.xValues[6]) / 2.0;
        this.yValues[5] = (this.yValues[4] + this.yValues[6]) / 2.0;
        this.xValues[4] = (this.xValues[3] + this.xValues[5]) / 2.0;
        this.yValues[4] = (this.yValues[3] + this.yValues[5]) / 2.0;
        this.xValues[6] = (this.xValues[5] + this.xValues[7]) / 2.0;
        this.yValues[6] = (this.yValues[5] + this.yValues[7]) / 2.0;
        this.xValues[2] = (this.xValues[1] + this.xValues[3]) / 2.0;
        this.yValues[2] = (this.yValues[1] + this.yValues[3]) / 2.0;
        this.xValues[7] = (this.xValues[6] + this.xValues[8]) / 2.0;
        this.yValues[7] = (this.yValues[6] + this.yValues[8]) / 2.0;
        this.xValues[5] = (this.xValues[4] + this.xValues[6]) / 2.0;
        this.yValues[5] = (this.yValues[4] + this.yValues[6]) / 2.0;
        this.xValues[4] = (this.xValues[3] + this.xValues[5]) / 2.0;
        this.yValues[4] = (this.yValues[3] + this.yValues[5]) / 2.0;
        this.xValues[6] = (this.xValues[5] + this.xValues[7]) / 2.0;
        this.yValues[6] = (this.yValues[5] + this.yValues[7]) / 2.0;
    }

    void suavizaTotal() {
        this.xValues[1] = (this.xValues[0] + this.xValues[2]) / 2.0;
        this.yValues[1] = (this.yValues[0] + this.yValues[2]) / 2.0;
        this.xValues[2] = (this.xValues[1] + this.xValues[3]) / 2.0;
        this.yValues[2] = (this.yValues[1] + this.yValues[3]) / 2.0;
        this.suavizaCentro();
        this.xValues[8] = (this.xValues[7] + this.xValues[9]) / 2.0;
        this.yValues[8] = (this.yValues[7] + this.yValues[9]) / 2.0;
        this.xValues[9] = (this.xValues[8] + this.xValues[10]) / 2.0;
        this.yValues[9] = (this.yValues[8] + this.yValues[10]) / 2.0;
    }

    void suavizaCentro() {
        this.xValues[3] = (this.xValues[2] + this.xValues[4]) / 2.0;
        this.yValues[3] = (this.yValues[2] + this.yValues[4]) / 2.0;
        this.xValues[4] = (this.xValues[3] + this.xValues[5]) / 2.0;
        this.yValues[4] = (this.yValues[3] + this.yValues[5]) / 2.0;
        this.xValues[5] = (this.xValues[4] + this.xValues[6]) / 2.0;
        this.yValues[5] = (this.yValues[4] + this.yValues[6]) / 2.0;
        this.xValues[6] = (this.xValues[5] + this.xValues[7]) / 2.0;
        this.yValues[6] = (this.yValues[5] + this.yValues[7]) / 2.0;
        this.xValues[7] = (this.xValues[6] + this.xValues[8]) / 2.0;
        this.yValues[7] = (this.yValues[6] + this.yValues[8]) / 2.0;
    }

    void myDoubleDrawPolygon(Graphics graphics) {
        Color color = this.color;
        Color color2 = this.colorNode;
        for (int i = 0; i < this.numberSubintervals - 1; ++i) {
            float f = (float)i / (float)(this.numberSubintervals - 1);
            int n = (int)((float)color2.getRed() * f + (float)color.getRed() * (1.0f - f));
            int n2 = (int)((float)color2.getGreen() * f + (float)color.getGreen() * (1.0f - f));
            int n3 = (int)((float)color2.getBlue() * f + (float)color.getBlue() * (1.0f - f));
            graphics.setColor(new Color(n, n2, n3));
            graphics.drawLine((int)this.xValues[i], (int)this.yValues[i], (int)this.xValues[i + 1], (int)this.yValues[i + 1]);
        }
    }

    void myDoubleDrawPolygon1(Graphics graphics) {
        for (int i = 0; i < this.numberSubintervals - 1; ++i) {
            graphics.drawLine((int)this.xValues[i], (int)this.yValues[i], (int)this.xValues[i + 1], (int)this.yValues[i + 1]);
        }
    }

    HTCoordE calcule(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        this.npoint.x = ((d2 - d6) * d7 - (d4 - d6) * d8) / d9;
        this.npoint.y = ((d5 - d) * d7 - (d5 - d3) * d8) / d9;
        return this.npoint;
    }

    boolean computeValues1() {
        double d = (this.xcoord[1] - this.xcoord[0]) / (double)this.numberSubintervals;
        double d2 = (this.ycoord[1] - this.ycoord[0]) / (double)this.numberSubintervals;
        this.xValues[0] = this.xcoord[0];
        this.yValues[0] = this.ycoord[0];
        this.xValues[this.numberSubintervals - 1] = this.xcoord[2];
        this.yValues[this.numberSubintervals - 1] = this.ycoord[2];
        boolean bl = this.calcParameters();
        if (!bl) {
            return false;
        }
        for (int i = 1; i < this.numberSubintervals - 1; ++i) {
            if (d != 0.0) {
                this.xValues[i] = this.xcoord[0] + d * (double)i;
                this.yValues[i] = this.PA * this.xValues[i] * this.xValues[i] + this.PB * this.xValues[i] + this.PC;
                continue;
            }
            if (d2 != 0.0) {
                this.xValues[i] = this.xcoord[0];
                this.yValues[i] = this.yValues[i] + d2;
                continue;
            }
            this.yValues[i] = this.ycoord[0];
            this.xValues[i] = this.xValues[i] + d;
        }
        return true;
    }

    boolean calcParameters() {
        double d = this.xcoord[0];
        double d2 = this.xcoord[1];
        double d3 = this.xcoord[2];
        double d4 = this.ycoord[0];
        double d5 = this.ycoord[1];
        double d6 = this.ycoord[2];
        try {
            this.PA = ((d5 - d4) * (d - d3) + (d6 - d4) * (d2 - d)) / ((d - d3) * (d2 * d2 - d * d) + (d2 - d) * (d3 * d3 - d * d));
            this.PB = (d5 - d4 - this.PA * (d2 * d2 - d * d)) / (d2 - d);
            this.PC = d4 - this.PA * d * d - this.PB * d;
            return true;
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            return false;
        }
    }
}

