/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;
import java.util.Enumeration;

class HTModelNode {
    private HTNode node = null;
    protected HTModel model = null;
    protected HTModelNodeComposite parent = null;
    protected HTCoordE z = null;
    protected double weight = 1.0;

    HTModelNode(HTNode hTNode, HTModel hTModel) {
        this(hTNode, null, hTModel);
    }

    public HTNode getHTNode() {
        return this.node;
    }

    HTModelNode(HTNode hTNode, HTModelNodeComposite hTModelNodeComposite, HTModel hTModel) {
        this.node = hTNode;
        this.parent = hTModelNodeComposite;
        this.model = hTModel;
        hTModel.incrementNumberOfNodes();
        this.z = new HTCoordE();
    }

    public Enumeration childrenNode() {
        return this.node.children();
    }

    String getName() {
        return this.node.getName();
    }

    String getNameImage() {
        return this.node.getNameImage();
    }

    String getColor() {
        return this.node.getColor();
    }

    String getTextColor() {
        return this.node.getTextColor();
    }

    String getURL() {
        return this.node.getURL();
    }

    String getID() {
        return this.node.getID();
    }

    public String getHint() {
        return this.node.getHint();
    }

    double getWeight() {
        return this.weight;
    }

    HTModelNodeComposite getParent() {
        return this.parent;
    }

    public boolean getHasHintPai() {
        HTNode hTNode = null;
        if (this.parent != null) {
            hTNode = this.parent.getHTnode();
        }
        if (hTNode != null) {
            return hTNode.getHasHint();
        }
        return false;
    }

    boolean isLeaf() {
        return true;
    }

    public boolean isLeafNode() {
        return this.node.isLeafNode();
    }

    String getNodeClientData() {
        return this.node.getNodeClientData();
    }

    public void setNodeClientData(String string) {
        this.node.setNodeClientData(string);
    }

    String getNameArest() {
        return this.node.getNameArest();
    }

    void setEspecialMark(boolean bl) {
        this.node.setEspecialMark(bl);
    }

    boolean getEspecialMark() {
        return this.node.getEspecialMark();
    }

    public boolean getHasHint() {
        return this.node.getHasHint();
    }

    public void setHasHint(boolean bl) {
        this.node.setHasHint(bl);
    }

    public void setHasData(boolean bl) {
        this.node.setHasData(bl);
    }

    public boolean getHasData() {
        return this.node.getHasData();
    }

    void setHasArc(boolean bl) {
        this.node.setHasArc(bl);
    }

    boolean getHasArc() {
        return this.node.getHasArc();
    }

    public HTNode getHTnode() {
        return this.node;
    }

    public BufferedImage getImage() {
        return this.node.getImage();
    }

    HTCoordE getCoordinates() {
        return this.z;
    }

    void layoutHyperbolicTree() {
        this.layout(0.0, Math.PI, this.model.getLength());
    }

    void layout(double d, double d2, double d3) {
        if (this.parent == null) {
            return;
        }
        HTCoordE hTCoordE = this.parent.getCoordinates();
        this.z.x = d3 * Math.cos(d);
        this.z.y = d3 * Math.sin(d);
        this.z.translate(hTCoordE);
    }

    public String toString() {
        String string = this.getName() + "\n\t" + this.z + "\n\tWeight = " + this.weight;
        return string;
    }

    public void setNodeClientStatus(String string) {
        this.node.setNodeClientStatus(string);
    }

    public int getIndicePoligono() {
        return this.node.getIndicePoligono();
    }

    public void saveXY(int n, int n2) {
        this.node.saveXY(n, n2);
    }

    public int getSavedX() {
        return this.node.getSavedX();
    }

    public int getSavedY() {
        return this.node.getSavedY();
    }

    public HTNode getNode() {
        return this.node;
    }
}

