/*
 * Decompiled with CFR 0.152.
 */
package classes;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.RectangularShape;
import java.util.Vector;

public class Amostra {
    public Vector pontosBorda;
    public int[][] amostraMascara;
    private int xCentro;
    private int yCentro;
    private int raio;
    public GeneralPath amostraGP;
    public int xMin;
    public int yMin;
    public int xMax;
    public int yMax;
    public int largura;
    public int altura;
    private Color corBorda = Color.blue;
    private Color corPontos = Color.green;
    private int nPontosBorda;

    public Amostra(double d, double d2, double d3, int n) {
        this.nPontosBorda = n;
        this.pontosBorda = new Vector();
        this.amostraGP = new GeneralPath();
        this.xCentro = Math.round((float)d);
        this.yCentro = Math.round((float)d2);
        this.raio = Math.round((float)d3);
        this.calculaPontosBorda();
        this.calculaParametros();
        this.criaMascara();
    }

    public int retornaXOrigem() {
        return this.xMin;
    }

    public int retornaYOrigem() {
        return this.yMin;
    }

    public int retornaLargura() {
        return this.largura;
    }

    public int retornaAltura() {
        return this.altura;
    }

    public GeneralPath retornaGP() {
        return this.amostraGP;
    }

    public int[][] retornaMascara() {
        return this.amostraMascara;
    }

    public int[][] adicionaMoldura(int[][] nArray, int n) {
        int n2 = nArray.length;
        int n3 = nArray[0].length;
        int[][] nArray2 = new int[n2 + 2 * n][n3 + 2 * n];
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                nArray2[j + n][i + n] = nArray[j][i];
            }
        }
        return nArray2;
    }

    public int[][] removerMoldura(int[][] nArray, int n) {
        int n2 = nArray.length - 2 * n;
        int n3 = nArray[0].length - 2 * n;
        int[][] nArray2 = new int[n2][n3];
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                nArray2[j][i] = nArray[j + n][i + n];
            }
        }
        return nArray2;
    }

    public void desenhaBorda(Graphics2D graphics2D) {
        Ellipse2D.Float float_ = new Ellipse2D.Float();
        graphics2D.setColor(this.corPontos);
        int n = this.pontosBorda.size();
        for (int i = 0; i < n; ++i) {
            Point point = (Point)this.pontosBorda.get(i);
            int n2 = point.x;
            int n3 = point.y;
            ((RectangularShape)float_).setFrame(n2 - 4, n3 - 4, 9.0, 9.0);
            graphics2D.fill(float_);
        }
        graphics2D.setColor(this.corBorda);
        graphics2D.draw(this.amostraGP);
    }

    public void atribuiCorBorda(Color color) {
        this.corBorda = color;
    }

    public void atribuiCorPontos(Color color) {
        this.corPontos = color;
    }

    public void move(int n, int n2) {
        int n3 = this.pontosBorda.size();
        for (int i = 0; i < n3; ++i) {
            Point point = (Point)this.pontosBorda.get(i);
            point.setLocation(point.x + n, point.y + n2);
        }
        this.amostraGP.reset();
        this.calculaParametros();
        this.amostraMascara = null;
        this.criaMascara();
    }

    public int achaPontoBorda(int n, int n2) {
        int n3 = -1;
        int n4 = this.pontosBorda.size();
        for (int i = 0; i < n4; ++i) {
            Point point = (Point)this.pontosBorda.get(i);
            if (Math.abs(point.x - n) >= 10 || Math.abs(point.y - n2) >= 10) continue;
            n3 = i;
            break;
        }
        return n3;
    }

    public void atualizaPontoBorda(int n, int n2, int n3) {
        Point point = (Point)this.pontosBorda.get(n);
        point.setLocation(n2, n3);
        this.amostraGP.reset();
        this.calculaParametros();
        this.amostraMascara = null;
        this.criaMascara();
    }

    private void calculaPontosBorda() {
        double d = 360 / this.nPontosBorda;
        for (int i = 0; i < this.nPontosBorda; ++i) {
            double d2 = Math.toRadians((double)i * d);
            int n = Math.round((float)((double)this.xCentro + (double)this.raio * Math.cos(d2)));
            int n2 = Math.round((float)((double)this.yCentro + (double)this.raio * Math.sin(d2)));
            this.pontosBorda.addElement(new Point(n, n2));
        }
    }

    private void calculaParametros() {
        int n;
        float[] fArray = null;
        float[] fArray2 = null;
        int n2 = this.pontosBorda.size();
        fArray = new float[n2];
        fArray2 = new float[n2];
        Point point = (Point)this.pontosBorda.get(0);
        this.xMin = point.x;
        this.xMax = point.x;
        this.yMin = point.y;
        this.yMax = point.y;
        for (n = 0; n < n2; ++n) {
            point = (Point)this.pontosBorda.get(n);
            fArray[n] = point.x;
            fArray2[n] = point.y;
            this.xMin = (int)Math.min((float)this.xMin, fArray[n]);
            this.yMin = (int)Math.min((float)this.yMin, fArray2[n]);
            this.xMax = (int)Math.max((float)this.xMax, fArray[n]);
            this.yMax = (int)Math.max((float)this.yMax, fArray2[n]);
        }
        this.largura = this.xMax - this.xMin + 1;
        this.altura = this.yMax - this.yMin + 1;
        this.amostraGP.moveTo(fArray[0], fArray2[0]);
        for (n = 1; n < n2; ++n) {
            this.amostraGP.lineTo(fArray[n], fArray2[n]);
        }
        this.amostraGP.closePath();
    }

    private void criaMascara() {
        int n;
        int n2;
        this.amostraMascara = new int[this.largura][this.altura];
        for (n2 = 0; n2 < this.altura; ++n2) {
            for (n = 0; n < this.largura; ++n) {
                this.amostraMascara[n][n2] = 0;
            }
        }
        int n3 = 0;
        for (n2 = this.yMin; n2 <= this.yMax; ++n2) {
            int n4 = 0;
            for (n = this.xMin; n <= this.xMax; ++n) {
                if (this.amostraGP.contains(n, n2)) {
                    this.amostraMascara[n4][n3] = 1;
                }
                ++n4;
            }
            ++n3;
        }
    }
}

