/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.FiltrosImagem;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;

public class Imagem {
    private int[][] vetorPixels;
    private int altura;
    private int largura;
    private int numBandas;
    private int[][] maskPixels;
    File arquivoImagem;
    private String nomeArquivoImagem;
    BufferedImage biImagem = null;

    public Imagem() {
        JFileChooser jFileChooser = new JFileChooser();
        String string = System.getProperty("user.dir");
        String string2 = string + "\\..\\imagens";
        jFileChooser.setCurrentDirectory(new File(string2));
        jFileChooser.setDialogTitle("Abre imagem");
        jFileChooser.addChoosableFileFilter(new FiltrosImagem());
        jFileChooser.setAcceptAllFileFilterUsed(false);
        int n = jFileChooser.showOpenDialog(null);
        if (n == 0) {
            this.arquivoImagem = jFileChooser.getSelectedFile();
            this.abreImagem();
            this.altura = this.biImagem.getHeight();
            this.largura = this.biImagem.getWidth();
            this.matrizDePixels();
            System.out.println("Arquivo: " + this.arquivoImagem.getParent() + " --- " + this.arquivoImagem.getName());
            System.out.println("#bandas = " + this.numBandas);
        } else if (n == 1) {
            this.arquivoImagem = null;
        }
    }

    public Imagem(File file) {
        this.arquivoImagem = file;
        this.abreImagem();
        this.altura = this.biImagem.getHeight();
        this.largura = this.biImagem.getWidth();
        this.matrizDePixels();
        System.out.println("Arquivo: " + this.arquivoImagem.getParent() + " --- " + this.arquivoImagem.getName());
        System.out.println("#bandas = " + this.numBandas);
    }

    public Imagem(int[][][] nArray) {
        this.numBandas = nArray.length;
        this.largura = nArray[0].length;
        this.altura = nArray[0][0].length;
        this.arquivoImagem = null;
        this.abreImagem(nArray);
        this.matrizDePixels();
    }

    public int[][] retornaVetorPixels() {
        return this.vetorPixels;
    }

    public int retornaLargura() {
        return this.largura;
    }

    public int retornaAltura() {
        return this.altura;
    }

    public int retornaBandas() {
        return this.numBandas;
    }

    public void atribuiMascara(int[][] nArray) {
        this.maskPixels = nArray;
    }

    public int[][] retornaMascara() {
        return this.maskPixels;
    }

    public BufferedImage retornaBI() {
        return this.biImagem;
    }

    public String retornaNomeArquivoImagem() {
        if (this.arquivoImagem != null) {
            this.nomeArquivoImagem = this.arquivoImagem.getName();
            return this.nomeArquivoImagem;
        }
        return null;
    }

    private void abreImagem() {
        try {
            this.biImagem = ImageIO.read(this.arquivoImagem);
            this.numBandas = this.biImagem.getSampleModel().getNumBands();
        }
        catch (Exception exception) {
            this.biImagem = null;
            System.out.println("Problema lendo '" + this.arquivoImagem + "'.");
        }
    }

    private void abreImagem(int[][][] nArray) {
        int n = 5;
        this.biImagem = new BufferedImage(this.largura, this.altura, n);
        WritableRaster writableRaster = this.biImagem.getRaster();
        for (int i = 0; i < this.altura; ++i) {
            for (int j = 0; j < this.largura; ++j) {
                writableRaster.setSample(j, i, 0, nArray[0][j][i]);
                writableRaster.setSample(j, i, 1, nArray[1][j][i]);
                writableRaster.setSample(j, i, 2, nArray[2][j][i]);
            }
        }
    }

    private void matrizDePixels() {
        WritableRaster writableRaster = this.biImagem.getRaster();
        this.vetorPixels = new int[this.numBandas][this.largura * this.altura];
        for (int i = 0; i < this.altura; ++i) {
            for (int j = 0; j < this.largura; ++j) {
                int n = i * this.largura + j;
                for (int k = 0; k < this.numBandas; ++k) {
                    this.vetorPixels[k][n] = writableRaster.getSample(j, i, k);
                }
            }
        }
    }
}

