/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Amostra;
import classes.Cluster;
import classes.Imagem;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ImagemPainel
extends JPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private Image m_image;
    private Vector vetorAmostras;
    private Vector roi;
    private Graphics2D g2D;
    private BufferedImage imagemOriginal;
    private BufferedImage imagemBuckUp;
    private int numeroCluster = 0;
    private int nPontos = 0;
    private int indiceAmostra = -1;
    private int xAnt;
    private int yAnt;
    private int xAtual;
    private int yAtual;
    private int amostraPontos;
    private int indPonto = -1;
    private int[][] mascaraPlanta;
    private int[] grupos;
    private double m_zoomPercentage;
    private double m_zoom = 1.0;
    private double diamAmostra;
    private double[][] pontos = new double[3][2];
    private boolean zoomFlag = false;
    private boolean flagUsaDiametro = false;
    private boolean flagMoveAmostra = true;
    private Amostra amostraSelecionada;
    private Imagem image;
    private static String nomeArquivo;

    public ImagemPainel(Imagem imagem, double d, int n) {
        this.amostraPontos = n;
        this.image = imagem;
        if (this.image.retornaNomeArquivoImagem() != null) {
            nomeArquivo = this.image.retornaNomeArquivoImagem();
        }
        this.imagemOriginal = this.image.retornaBI();
        WritableRaster writableRaster = this.imagemOriginal.copyData(null);
        this.imagemBuckUp = new BufferedImage(this.imagemOriginal.getColorModel(), writableRaster, false, null);
        this.amostraSelecionada = null;
        this.m_image = new ImageIcon(this.imagemOriginal).getImage();
        this.m_zoomPercentage = d / 100.0;
        this.addMouseListener(this);
        this.addMouseWheelListener(this);
        this.addMouseMotionListener(this);
        this.vetorAmostras = new Vector();
        this.roi = new Vector();
    }

    public void atribuiImagem(Imagem imagem, double d, int n) {
        this.amostraPontos = n;
        this.image = null;
        this.m_image = null;
        this.image = imagem;
        this.imagemBuckUp = null;
        this.imagemOriginal = this.image.retornaBI();
        WritableRaster writableRaster = this.imagemOriginal.copyData(null);
        this.imagemBuckUp = new BufferedImage(this.imagemOriginal.getColorModel(), writableRaster, false, null);
        this.amostraSelecionada = null;
        this.m_image = new ImageIcon(this.imagemOriginal).getImage();
        this.m_zoomPercentage = d / 100.0;
        this.addMouseListener(this);
        this.addMouseWheelListener(this);
        this.addMouseMotionListener(this);
        this.vetorAmostras.removeAllElements();
        this.roi.removeAllElements();
    }

    public void limpa() {
        this.image = null;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        this.g2D = (Graphics2D)graphics;
        boolean bl = false;
        boolean bl2 = false;
        this.g2D.setColor(Color.LIGHT_GRAY);
        this.g2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.g2D.scale(this.m_zoom, this.m_zoom);
        this.g2D.drawImage(this.m_image, 0, 0, this);
        int n = this.vetorAmostras.size();
        for (int i = 0; i < n; ++i) {
            Amostra amostra = (Amostra)this.vetorAmostras.get(i);
            amostra.desenhaBorda(this.g2D);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension((int)((double)this.m_image.getWidth(this) + (double)this.m_image.getWidth(this) * (this.m_zoom - 1.0)), (int)((double)this.m_image.getHeight(this) + (double)this.m_image.getHeight(this) * (this.m_zoom - 1.0)));
    }

    public void setZoomPercentage(int n) {
        this.m_zoomPercentage = (double)n / 100.0;
    }

    public void originalSize() {
        this.m_zoom = 1.0;
        this.zoomFlag = true;
    }

    public void zoomIn() {
        this.m_zoom += this.m_zoomPercentage;
        this.zoomFlag = true;
    }

    public void setZoom(double d) {
        this.m_zoom = d / 100.0;
        this.zoomFlag = true;
    }

    public void zoomOut() {
        this.m_zoom -= this.m_zoomPercentage;
        if (this.m_zoom < this.m_zoomPercentage) {
            if (this.m_zoomPercentage > 1.0) {
                this.m_zoom = 1.0;
            } else {
                this.zoomIn();
            }
        }
        this.zoomFlag = true;
    }

    public double getZoomedTo() {
        return this.m_zoom * 100.0;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.amostraSelecionada != null) {
            this.xAnt = this.xAtual;
            this.yAnt = this.yAtual;
            this.xAtual = mouseEvent.getX();
            this.yAtual = mouseEvent.getY();
            int n = this.xAtual - this.xAnt;
            int n2 = this.yAtual - this.yAnt;
            if (this.flagMoveAmostra) {
                this.amostraSelecionada.move(n, n2);
            } else if (this.indPonto >= 0) {
                this.amostraSelecionada.atualizaPontoBorda(this.indPonto, this.xAtual, this.yAtual);
            }
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.xAtual = mouseEvent.getX();
        this.yAtual = mouseEvent.getY();
        this.indPonto = -1;
        Amostra amostra = this.retornaAmostra(this.xAtual, this.yAtual);
        if (amostra != null) {
            if (this.amostraSelecionada != amostra) {
                this.selecionaAmostra(amostra);
                this.nPontos = 0;
            } else {
                this.indPonto = this.amostraSelecionada.achaPontoBorda(this.xAtual, this.yAtual);
                this.flagMoveAmostra = this.indPonto < 0;
            }
        } else if (this.amostraSelecionada != null) {
            this.indPonto = this.amostraSelecionada.achaPontoBorda(this.xAtual, this.yAtual);
            if (this.indPonto >= 0) {
                this.flagMoveAmostra = false;
            } else {
                this.selecionaAmostra(null);
                this.pontos[this.nPontos][0] = mouseEvent.getX();
                this.pontos[this.nPontos][1] = mouseEvent.getY();
                if (this.nPontos == 2) {
                    double[] dArray = this.calculaRaio();
                    Amostra amostra2 = new Amostra(dArray[0], dArray[1], dArray[2], this.amostraPontos);
                    this.vetorAmostras.addElement(amostra2);
                    this.selecionaAmostra(amostra2);
                    this.nPontos = 0;
                } else {
                    ++this.nPontos;
                }
            }
        } else {
            this.pontos[this.nPontos][0] = mouseEvent.getX();
            this.pontos[this.nPontos][1] = mouseEvent.getY();
            if (this.nPontos == 2) {
                double[] dArray = this.calculaRaio();
                Amostra amostra3 = new Amostra(dArray[0], dArray[1], dArray[2], this.amostraPontos);
                this.vetorAmostras.addElement(amostra3);
                this.selecionaAmostra(amostra3);
                this.nPontos = 0;
            } else {
                ++this.nPontos;
            }
        }
    }

    public void adicionaAmostra(double d) {
        this.diamAmostra = d;
        this.flagUsaDiametro = true;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
    }

    public void moveAmostra(int n, int n2) {
        if (this.amostraSelecionada != null) {
            this.amostraSelecionada.move(n, n2);
            this.repaint();
        }
    }

    private void selecionaAmostra(Amostra amostra) {
        if (amostra == null) {
            if (this.amostraSelecionada != null) {
                this.amostraSelecionada.atribuiCorBorda(Color.blue);
                this.amostraSelecionada = amostra;
                this.indiceAmostra = -1;
            }
        } else {
            int n = this.vetorAmostras.indexOf(amostra);
            if (this.amostraSelecionada != null) {
                this.amostraSelecionada.atribuiCorBorda(Color.blue);
            }
            this.amostraSelecionada = amostra;
            this.indiceAmostra = n;
            this.amostraSelecionada.atribuiCorBorda(Color.red);
        }
        this.repaint();
    }

    private Amostra retornaAmostra(int n, int n2) {
        Amostra amostra = null;
        int n3 = this.vetorAmostras.size();
        for (int i = 0; i < n3; ++i) {
            Amostra amostra2 = (Amostra)this.vetorAmostras.get(i);
            GeneralPath generalPath = amostra2.amostraGP;
            if (!generalPath.contains(n, n2)) continue;
            amostra = amostra2;
            break;
        }
        return amostra;
    }

    private double[] calculaRaio() {
        double[] dArray = new double[3];
        double d = this.pontos[0][0];
        double d2 = this.pontos[0][1];
        double d3 = this.pontos[1][0];
        double d4 = this.pontos[1][1];
        double d5 = this.pontos[2][0];
        double d6 = this.pontos[2][1];
        double d7 = d5 * d5 - d5 * d3 - d * d5 + d * d3 + d6 * d6 - d6 * d4 - d2 * d6 + d2 * d4;
        double d8 = d5 * d2 - d5 * d4 + d * d4 - d * d6 + d3 * d6 - d3 * d2;
        double d9 = d8 == 0.0 ? 0.0 : d7 / d8;
        double d10 = d9 * d4 - d3 - d - d9 * d2;
        double d11 = d9 * d - d2 - d4 - d3 * d9;
        double d12 = d * d3 + d2 * d4 - d9 * d * d4 + d9 * d3 * d2;
        double d13 = d10 / 2.0;
        double d14 = d11 / 2.0;
        double d15 = d13 * d13 + d14 * d14 - d12;
        double d16 = Math.pow(d15, 0.5);
        dArray[0] = Math.abs(d13);
        dArray[1] = Math.abs(d14);
        dArray[2] = d16;
        return dArray;
    }

    public int[][] retornaMascara() {
        int[][] nArray = null;
        if (this.amostraSelecionada != null) {
            nArray = this.amostraSelecionada.amostraMascara;
        }
        return nArray;
    }

    public int[][][] recortaAmostra() {
        int[][][] nArray = null;
        int[][] nArray2 = null;
        int[][] nArray3 = null;
        double[][] dArray = null;
        if (this.amostraSelecionada != null) {
            int n;
            int n2;
            int n3;
            int n4 = this.amostraSelecionada.xMin;
            int n5 = this.amostraSelecionada.xMax;
            int n6 = this.amostraSelecionada.yMin;
            int n7 = this.amostraSelecionada.yMax;
            int n8 = this.amostraSelecionada.largura;
            int n9 = this.amostraSelecionada.altura;
            nArray2 = this.amostraSelecionada.amostraMascara;
            BufferedImage bufferedImage = this.image.retornaBI();
            int n10 = this.image.retornaBandas();
            nArray = new int[n10][n8][n9];
            WritableRaster writableRaster = bufferedImage.getRaster();
            for (n3 = 0; n3 < n9; ++n3) {
                for (n2 = 0; n2 < n8; ++n2) {
                    for (n = 0; n < n10; ++n) {
                        nArray[n][n2][n3] = 0;
                    }
                }
            }
            int n11 = 0;
            for (n3 = n6; n3 < n7; ++n3) {
                int n12 = 0;
                for (n2 = n4; n2 < n5; ++n2) {
                    if (nArray2[n12][n11] > 0) {
                        for (n = 0; n < n10; ++n) {
                            int n13;
                            nArray[n][n12][n11] = n13 = writableRaster.getSample(n2, n3, n);
                        }
                    }
                    ++n12;
                }
                ++n11;
            }
        }
        return nArray;
    }

    public void calculaKmedias(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        boolean bl = false;
        int n7 = 0;
        int n8 = 0;
        String[] stringArray = new String[]{"Vermelho", "Verde", "Azul", "Rosa", "Turquesa", "Amarelo", "Violeta"};
        int n9 = this.image.retornaAltura();
        int n10 = this.image.retornaLargura();
        int n11 = this.image.retornaBandas();
        int[][] nArray = this.image.retornaMascara();
        int[][] nArray2 = this.image.retornaVetorPixels();
        Cluster cluster = new Cluster();
        for (n5 = 0; n5 < n9; ++n5) {
            for (n4 = 0; n4 < n10; ++n4) {
                if (nArray[n4][n5] <= 0) continue;
                ++n8;
            }
        }
        int[][] nArray3 = new int[n8][n11];
        for (n5 = 0; n5 < n11; ++n5) {
            n8 = 0;
            for (n4 = 0; n4 < n9; ++n4) {
                for (int i = 0; i < n10; ++i) {
                    int n12 = n4 * n10 + i;
                    if (nArray[i][n4] <= 0) continue;
                    nArray3[n8][n5] = nArray2[n5][n12];
                    ++n8;
                }
            }
        }
        int n13 = nArray3[0].length;
        int n14 = nArray3.length;
        this.grupos = new int[n14];
        this.numeroCluster = n3 = (n2 = n);
        for (n5 = n3; n5 <= n2; ++n5) {
            if (!bl) {
                n7 = 0;
                for (n4 = 0; n4 < n14; ++n4) {
                    if (++n7 > n5) {
                        n7 -= n5;
                    }
                    this.grupos[n4] = n7;
                }
            }
            this.grupos = cluster.kMeans(nArray3, this.grupos, n5, n6);
        }
        this.criaImagemCluster(this.grupos, n10, n9, "kMed");
        System.out.println("calculaKmedias::nomeArquivo: " + nomeArquivo);
        nArray3 = null;
        int n15 = n;
        int[] nArray4 = new int[n15];
        for (n5 = 0; n5 < n14; ++n5) {
            int n16 = this.grupos[n5] - 1;
            nArray4[n16] = nArray4[n16] + 1;
        }
        System.out.println("Estatisticas: #pixels/grupo\n");
        for (n5 = 1; n5 <= n15; ++n5) {
            double d = nArray4[n5 - 1] * 100 / n8;
            System.out.println("Grupo " + n5 + " (" + stringArray[n5 - 1] + "): " + nArray4[n5 - 1] + " pixels. (" + d + "%)");
        }
        this.gravaArquivoCSV(nArray4, n15, n8, stringArray, "kMed");
    }

    private void criaImagemCluster(int[] nArray, int n, int n2, String string) {
        Object object;
        int n3;
        int n4 = 0;
        int[][] nArray2 = this.image.retornaMascara();
        int[][] nArray3 = this.image.retornaVetorPixels();
        int[][] nArray4 = new int[n][n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                if (nArray2[j][i] > 0) {
                    nArray4[j][i] = nArray[n4];
                    ++n4;
                    continue;
                }
                nArray4[j][i] = 0;
            }
        }
        int n5 = 5;
        BufferedImage bufferedImage = new BufferedImage(n, n2, n5);
        WritableRaster writableRaster = bufferedImage.getRaster();
        for (int i = 0; i < n2; ++i) {
            block14: for (n3 = 0; n3 < n; ++n3) {
                if (nArray4[n3][i] <= 0) continue;
                int n6 = nArray4[n3][i];
                int n7 = n3 + i * n;
                switch (n6) {
                    case 1: {
                        writableRaster.setSample(n3, i, 0, 255);
                        writableRaster.setSample(n3, i, 1, 0);
                        writableRaster.setSample(n3, i, 2, 0);
                        continue block14;
                    }
                    case 2: {
                        writableRaster.setSample(n3, i, 0, 0);
                        writableRaster.setSample(n3, i, 1, 255);
                        writableRaster.setSample(n3, i, 2, 0);
                        continue block14;
                    }
                    case 3: {
                        writableRaster.setSample(n3, i, 0, 0);
                        writableRaster.setSample(n3, i, 1, 0);
                        writableRaster.setSample(n3, i, 2, 255);
                        continue block14;
                    }
                    case 4: {
                        writableRaster.setSample(n3, i, 0, 255);
                        writableRaster.setSample(n3, i, 1, 0);
                        writableRaster.setSample(n3, i, 2, 255);
                        continue block14;
                    }
                    case 5: {
                        writableRaster.setSample(n3, i, 0, 0);
                        writableRaster.setSample(n3, i, 1, 255);
                        writableRaster.setSample(n3, i, 2, 255);
                        continue block14;
                    }
                    case 6: {
                        writableRaster.setSample(n3, i, 0, 255);
                        writableRaster.setSample(n3, i, 1, 255);
                        writableRaster.setSample(n3, i, 2, 0);
                        continue block14;
                    }
                    case 7: {
                        writableRaster.setSample(n3, i, 0, 128);
                        writableRaster.setSample(n3, i, 1, 0);
                        writableRaster.setSample(n3, i, 2, 255);
                    }
                }
            }
        }
        try {
            object = ".";
            n3 = nomeArquivo.indexOf((String)object);
            String string2 = nomeArquivo.substring(0, n3);
            string2 = string2 + "_" + String.valueOf(this.numeroCluster) + string;
            System.out.println("\nCriando arquivo imagem '" + string2 + ".png' em ..\\temp\\" + "\n");
            ImageIO.write((RenderedImage)bufferedImage, "png", new File("..\\temp\\" + string2 + ".png"));
        }
        catch (IOException iOException) {
            String string3 = "criaImagemCluster::Problema gravando arquivo imgCluster.";
            JOptionPane.showMessageDialog(this, string3);
            System.exit(0);
        }
        object = this.imagemOriginal.createGraphics();
        this.imagemOriginal.setData(writableRaster);
        AffineTransform affineTransform = new AffineTransform();
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.5f);
        ((Graphics2D)object).setComposite(alphaComposite);
        ((Graphics2D)object).drawImage(this.imagemOriginal, affineTransform, this);
        this.repaint();
    }

    public void mostraClusterSelecionado(int[] nArray) {
        int n = 0;
        int n2 = this.image.retornaLargura();
        int n3 = this.image.retornaAltura();
        int[][] nArray2 = this.image.retornaMascara();
        int[][] nArray3 = this.image.retornaVetorPixels();
        int[][] nArray4 = new int[n2][n3];
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (nArray2[j][i] > 0) {
                    nArray4[j][i] = this.grupos[n];
                    ++n;
                    continue;
                }
                nArray4[j][i] = 0;
            }
        }
        WritableRaster writableRaster = this.imagemBuckUp.copyData(null);
        BufferedImage bufferedImage = new BufferedImage(this.imagemBuckUp.getColorModel(), writableRaster, false, null);
        WritableRaster writableRaster2 = bufferedImage.getRaster();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (nArray4[j][i] <= 0) continue;
                int n4 = nArray4[j][i];
                int n5 = j + i * n2;
                block13: for (int k = 0; k < 7; ++k) {
                    if (nArray[k] != 1 || n4 != k + 1) continue;
                    switch (n4) {
                        case 1: {
                            writableRaster2.setSample(j, i, 0, 255);
                            writableRaster2.setSample(j, i, 1, 0);
                            writableRaster2.setSample(j, i, 2, 0);
                            continue block13;
                        }
                        case 2: {
                            writableRaster2.setSample(j, i, 0, 0);
                            writableRaster2.setSample(j, i, 1, 255);
                            writableRaster2.setSample(j, i, 2, 0);
                            continue block13;
                        }
                        case 3: {
                            writableRaster2.setSample(j, i, 0, 0);
                            writableRaster2.setSample(j, i, 1, 0);
                            writableRaster2.setSample(j, i, 2, 255);
                            continue block13;
                        }
                        case 4: {
                            writableRaster2.setSample(j, i, 0, 255);
                            writableRaster2.setSample(j, i, 1, 0);
                            writableRaster2.setSample(j, i, 2, 255);
                            continue block13;
                        }
                        case 5: {
                            writableRaster2.setSample(j, i, 0, 0);
                            writableRaster2.setSample(j, i, 1, 255);
                            writableRaster2.setSample(j, i, 2, 255);
                            continue block13;
                        }
                        case 6: {
                            writableRaster2.setSample(j, i, 0, 255);
                            writableRaster2.setSample(j, i, 1, 255);
                            writableRaster2.setSample(j, i, 2, 0);
                            continue block13;
                        }
                        case 7: {
                            writableRaster2.setSample(j, i, 0, 128);
                            writableRaster2.setSample(j, i, 1, 0);
                            writableRaster2.setSample(j, i, 2, 255);
                        }
                    }
                }
            }
        }
        Graphics2D graphics2D = this.imagemOriginal.createGraphics();
        this.imagemOriginal.setData(writableRaster2);
        AffineTransform affineTransform = new AffineTransform();
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.5f);
        graphics2D.setComposite(alphaComposite);
        graphics2D.drawImage(this.imagemOriginal, affineTransform, this);
        this.repaint();
    }

    private void gravaArquivoCSV(int[] nArray, int n, int n2, String[] stringArray, String string) {
        String string2 = ";";
        String string3 = ".";
        int n3 = nomeArquivo.indexOf(string3);
        String string4 = nomeArquivo.substring(0, n3);
        String string5 = "..\\temp\\" + string4 + "_" + String.valueOf(n) + string + ".csv";
        try {
            FileWriter fileWriter = new FileWriter(string5);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            for (int i = 1; i <= n; ++i) {
                String string6 = "";
                double d = nArray[i - 1] * 100 / n2;
                String string7 = "Grupo " + String.valueOf(i);
                String string8 = stringArray[i - 1];
                String string9 = String.valueOf(nArray[i - 1]);
                String string10 = String.valueOf(d);
                string6 = string7 + string2 + string8 + string2 + string9 + string2 + string10;
                this.grava_linha(string6, bufferedWriter);
            }
            bufferedWriter.close();
            System.out.println("\nCriando arquivo: " + string5 + "\n");
        }
        catch (IOException iOException) {
            String string11 = "ImagemPainel::Erro na grava\u00e7\u00e3o do arquivo " + string5;
            JOptionPane.showMessageDialog(this, string11);
            System.exit(0);
        }
    }

    private void grava_linha(String string, BufferedWriter bufferedWriter) {
        try {
            bufferedWriter.write(string);
            bufferedWriter.newLine();
        }
        catch (IOException iOException) {
            String string2 = "ImagemPainel::Erro na grava\u00e7\u00e3o da linha " + string;
            System.out.println(string2);
            System.exit(0);
        }
    }
}

