/*
 * Decompiled with CFR 0.152.
 */
package classes;

import java.text.DecimalFormat;
import java.util.Arrays;

public class Matriz {
    private int nrow = 0;
    private int ncol = 0;
    private double[][] matriz = null;
    private int[] index = null;
    private double dswap = 1.0;
    private boolean matrizCheck = true;
    private double[][] eigen = null;
    private static final double TINY = 1.0E-30;

    public Matriz(int n, int n2) {
        this.nrow = n;
        this.ncol = n2;
        this.matriz = new double[n][n2];
        this.index = new int[n];
        for (int i = 0; i < n; ++i) {
            this.index[i] = i;
        }
    }

    public Matriz(int n, int n2, double d) {
        int n3;
        this.nrow = n;
        this.ncol = n2;
        this.matriz = new double[n][n2];
        for (n3 = 0; n3 < n; ++n3) {
            for (int i = 0; i < n; ++i) {
                this.matriz[n3][i] = d;
            }
        }
        this.index = new int[n];
        for (n3 = 0; n3 < n; ++n3) {
            this.index[n3] = n3;
        }
    }

    public Matriz(double[][] dArray) {
        int n;
        this.nrow = dArray.length;
        this.ncol = dArray[0].length;
        for (n = 0; n < this.nrow; ++n) {
            if (dArray[n].length == this.ncol) continue;
            throw new IllegalArgumentException("All rows must have the same length");
        }
        this.matriz = dArray;
        this.eigen = new double[this.nrow][this.ncol];
        this.index = new int[this.nrow];
        for (n = 0; n < this.nrow; ++n) {
            this.index[n] = n;
        }
    }

    public Matriz(Matriz matriz) {
        this.nrow = matriz.nrow;
        this.ncol = matriz.ncol;
        this.matriz = matriz.matriz;
        this.index = matriz.index;
        this.dswap = matriz.dswap;
    }

    public void setTwoDarray(double[][] dArray) {
        String string = "row length of this ComplexMatriz differs from that of the 2D array argument";
        String string2 = "column length of this ComplexMatriz differs from that of the 2D array argument";
        String string3 = "All rows must have the same length";
        if (this.nrow != dArray.length) {
            throw new IllegalArgumentException(string);
        }
        if (this.ncol != dArray[0].length) {
            throw new IllegalArgumentException(string2);
        }
        for (int i = 0; i < this.nrow; ++i) {
            if (dArray[i].length != this.ncol) {
                throw new IllegalArgumentException(string3);
            }
            for (int j = 0; j < this.ncol; ++j) {
                this.matriz[i][j] = dArray[i][j];
            }
        }
    }

    public void setElement(int n, int n2, double d) {
        this.matriz[n][n2] = d;
    }

    public void setSubMatriz(int n, int n2, int n3, int n4, double[][] dArray) {
        if (n > n3) {
            throw new IllegalArgumentException("row indices inverted");
        }
        if (n2 > n4) {
            throw new IllegalArgumentException("column indices inverted");
        }
        int n5 = n3 - n + 1;
        int n6 = n2 - n4 + 1;
        for (int i = 0; i < n5; ++i) {
            int n7 = 0;
            while (n7 < n6) {
                this.matriz[n + i][n2 + n7] = dArray[n][n2];
                ++i;
            }
        }
    }

    public void setSubMatriz(int[] nArray, int[] nArray2, double[][] dArray) {
        int n = nArray.length;
        int n2 = nArray2.length;
        for (int i = 0; i < n; ++i) {
            int n3 = 0;
            while (n3 < n2) {
                this.matriz[nArray[i]][nArray2[n3]] = dArray[i][n3];
                ++i;
            }
        }
    }

    public boolean getMatrizCheck() {
        return this.matrizCheck;
    }

    public static Matriz identityMatriz(int n) {
        Matriz matriz = new Matriz(n, n);
        for (int i = 0; i < n; ++i) {
            matriz.matriz[i][i] = 1.0;
        }
        return matriz;
    }

    public static Matriz scalarMatriz(int n, double d) {
        Matriz matriz = new Matriz(n, n);
        double[][] dArray = matriz.getArrayReference();
        for (int i = 0; i < n; ++i) {
            for (int j = i; j < n; ++j) {
                if (i != j) continue;
                dArray[i][j] = d;
            }
        }
        return matriz;
    }

    public static Matriz diagonalMatriz(int n, double[] dArray) {
        String string = "matriz dimension differs from diagonal array length";
        if (dArray.length != n) {
            throw new IllegalArgumentException(string);
        }
        Matriz matriz = new Matriz(n, n);
        double[][] dArray2 = matriz.getArrayReference();
        for (int i = 0; i < n; ++i) {
            dArray2[i][i] = dArray[i];
        }
        return matriz;
    }

    public int getNrow() {
        return this.nrow;
    }

    public int getNcol() {
        return this.ncol;
    }

    public double[][] getArrayReference() {
        return this.matriz;
    }

    public double[][] getArrayPointer() {
        return this.matriz;
    }

    public double[][] getArrayCopy() {
        double[][] dArray = new double[this.nrow][this.ncol];
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < this.ncol; ++j) {
                dArray[i][j] = this.matriz[i][j];
            }
        }
        return dArray;
    }

    public double getElement(int n, int n2) {
        return this.matriz[n][n2];
    }

    public double getElementCopy(int n, int n2) {
        return this.matriz[n][n2];
    }

    public double getElementPointer(int n, int n2) {
        return this.matriz[n][n2];
    }

    public Matriz getSubMatriz(int n, int n2, int n3, int n4) {
        if (n > n3) {
            throw new IllegalArgumentException("row indices inverted");
        }
        if (n2 > n4) {
            throw new IllegalArgumentException("column indices inverted");
        }
        int n5 = n3 - n + 1;
        int n6 = n2 - n4 + 1;
        Matriz matriz = new Matriz(n5, n6);
        double[][] dArray = this.getArrayReference();
        for (int i = 0; i < n5; ++i) {
            int n7 = 0;
            while (n7 < n6) {
                dArray[i][n7] = this.matriz[n + i][n2 + n7];
                ++i;
            }
        }
        return matriz;
    }

    public Matriz getSubMatriz(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        int n2 = nArray2.length;
        Matriz matriz = new Matriz(n, n2);
        double[][] dArray = this.getArrayReference();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = this.matriz[nArray[i]][nArray2[j]];
            }
        }
        return matriz;
    }

    public int[] getIndexReference() {
        return this.index;
    }

    public int[] getIndexPointer() {
        return this.index;
    }

    public int[] getIndexCopy() {
        int[] nArray = new int[this.nrow];
        for (int i = 0; i < this.nrow; ++i) {
            nArray[i] = this.index[i];
        }
        return nArray;
    }

    public double getSwap() {
        return this.dswap;
    }

    public static Matriz copy(Matriz matriz) {
        int n;
        if (matriz == null) {
            return null;
        }
        int n2 = matriz.getNrow();
        int n3 = matriz.getNcol();
        double[][] dArray = matriz.getArrayReference();
        Matriz matriz2 = new Matriz(n2, n3);
        matriz2.nrow = n2;
        matriz2.ncol = n3;
        double[][] dArray2 = matriz2.getArrayReference();
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                dArray2[n][i] = dArray[n][i];
            }
        }
        for (n = 0; n < n2; ++n) {
            matriz2.index[n] = matriz.index[n];
        }
        return matriz2;
    }

    public Matriz copy() {
        int n;
        if (this == null) {
            return null;
        }
        int n2 = this.nrow;
        int n3 = this.ncol;
        Matriz matriz = new Matriz(n2, n3);
        double[][] dArray = matriz.getArrayReference();
        matriz.nrow = n2;
        matriz.ncol = n3;
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                dArray[n][i] = this.matriz[n][i];
            }
        }
        for (n = 0; n < n2; ++n) {
            matriz.index[n] = this.index[n];
        }
        return matriz;
    }

    public Object clone() {
        int n;
        if (this == null) {
            return null;
        }
        int n2 = this.nrow;
        int n3 = this.ncol;
        Matriz matriz = new Matriz(n2, n3);
        double[][] dArray = matriz.getArrayReference();
        matriz.nrow = n2;
        matriz.ncol = n3;
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                dArray[n][i] = this.matriz[n][i];
            }
        }
        for (n = 0; n < n2; ++n) {
            matriz.index[n] = this.index[n];
        }
        return matriz;
    }

    public Matriz plus(Matriz matriz) {
        if (this.nrow != matriz.nrow || this.ncol != matriz.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int n = matriz.nrow;
        int n2 = matriz.ncol;
        Matriz matriz2 = new Matriz(n, n2);
        double[][] dArray = matriz2.getArrayReference();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = this.matriz[i][j] + matriz.matriz[i][j];
            }
        }
        return matriz2;
    }

    public static Matriz plus(Matriz matriz, Matriz matriz2) {
        if (matriz.nrow != matriz2.nrow || matriz.ncol != matriz2.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int n = matriz.nrow;
        int n2 = matriz.ncol;
        Matriz matriz3 = new Matriz(n, n2);
        double[][] dArray = matriz3.getArrayReference();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = matriz.matriz[i][j] + matriz2.matriz[i][j];
            }
        }
        return matriz3;
    }

    public void plusEquals(Matriz matriz) {
        if (this.nrow != matriz.nrow || this.ncol != matriz.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int n = matriz.nrow;
        int n2 = matriz.ncol;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                double[] dArray = this.matriz[i];
                int n3 = j;
                dArray[n3] = dArray[n3] + matriz.matriz[i][j];
            }
        }
    }

    public Matriz minus(Matriz matriz) {
        if (this.nrow != matriz.nrow || this.ncol != matriz.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int n = this.nrow;
        int n2 = this.ncol;
        Matriz matriz2 = new Matriz(n, n2);
        double[][] dArray = matriz2.getArrayReference();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = this.matriz[i][j] - matriz.matriz[i][j];
            }
        }
        return matriz2;
    }

    public static Matriz minus(Matriz matriz, Matriz matriz2) {
        if (matriz.nrow != matriz2.nrow || matriz.ncol != matriz2.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int n = matriz.nrow;
        int n2 = matriz.ncol;
        Matriz matriz3 = new Matriz(n, n2);
        double[][] dArray = matriz3.getArrayReference();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = matriz.matriz[i][j] - matriz2.matriz[i][j];
            }
        }
        return matriz3;
    }

    public void minusEquals(Matriz matriz) {
        if (this.nrow != matriz.nrow || this.ncol != matriz.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        int n = matriz.nrow;
        int n2 = matriz.ncol;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                double[] dArray = this.matriz[i];
                int n3 = j;
                dArray[n3] = dArray[n3] - matriz.matriz[i][j];
            }
        }
    }

    public Matriz times(Matriz matriz) {
        if (this.ncol != matriz.nrow) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        Matriz matriz2 = new Matriz(this.nrow, matriz.ncol);
        double[][] dArray = matriz2.getArrayReference();
        double d = 0.0;
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < matriz.ncol; ++j) {
                d = 0.0;
                for (int k = 0; k < this.ncol; ++k) {
                    d += this.matriz[i][k] * matriz.matriz[k][j];
                }
                dArray[i][j] = d;
            }
        }
        return matriz2;
    }

    public Matriz times(double d) {
        Matriz matriz = new Matriz(this.nrow, this.ncol);
        double[][] dArray = matriz.getArrayReference();
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < this.ncol; ++j) {
                dArray[i][j] = this.matriz[i][j] * d;
            }
        }
        return matriz;
    }

    public static Matriz times(Matriz matriz, Matriz matriz2) {
        if (matriz.ncol != matriz2.nrow) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        Matriz matriz3 = new Matriz(matriz.nrow, matriz2.ncol);
        double[][] dArray = matriz3.getArrayReference();
        double d = 0.0;
        for (int i = 0; i < matriz.nrow; ++i) {
            for (int j = 0; j < matriz2.ncol; ++j) {
                d = 0.0;
                for (int k = 0; k < matriz.ncol; ++k) {
                    d += matriz.matriz[i][k] * matriz2.matriz[k][j];
                }
                dArray[i][j] = d;
            }
        }
        return matriz3;
    }

    public static Matriz times(Matriz matriz, double d) {
        Matriz matriz2 = new Matriz(matriz.nrow, matriz.ncol);
        double[][] dArray = matriz2.getArrayReference();
        for (int i = 0; i < matriz.nrow; ++i) {
            for (int j = 0; j < matriz.ncol; ++j) {
                dArray[i][j] = matriz.matriz[i][j] * d;
            }
        }
        return matriz2;
    }

    public void timesEquals(Matriz matriz) {
        if (this.ncol != matriz.nrow) {
            throw new IllegalArgumentException("Nonconformable matrices");
        }
        double d = 0.0;
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < matriz.ncol; ++j) {
                d = 0.0;
                for (int k = 0; k < this.ncol; ++k) {
                    d += this.matriz[i][k] * matriz.matriz[k][j];
                }
                this.matriz[i][j] = d;
            }
        }
    }

    public void timesEquals(double d) {
        for (int i = 0; i < this.nrow; ++i) {
            int n = 0;
            while (n < this.ncol) {
                double[] dArray = this.matriz[i];
                int n2 = n++;
                dArray[n2] = dArray[n2] * d;
            }
        }
    }

    public Matriz inverse() {
        int n = this.nrow;
        if (n != this.ncol) {
            throw new IllegalArgumentException("Matriz is not square");
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        Matriz matriz = new Matriz(n, n);
        double[][] dArray3 = matriz.getArrayReference();
        Matriz matriz2 = this.luDecomp();
        for (int i = 0; i < n; ++i) {
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                dArray[n2] = 0.0;
            }
            dArray[i] = 1.0;
            dArray2 = matriz2.luBackSub(dArray);
            for (n2 = 0; n2 < n; ++n2) {
                dArray3[n2][i] = dArray2[n2];
            }
        }
        return matriz;
    }

    public static Matriz inverse(Matriz matriz) {
        int n = matriz.nrow;
        if (n != matriz.ncol) {
            throw new IllegalArgumentException("Matriz is not square");
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        Matriz matriz2 = new Matriz(n, n);
        double[][] dArray3 = matriz2.getArrayReference();
        Matriz matriz3 = matriz.luDecomp();
        for (int i = 0; i < n; ++i) {
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                dArray[n2] = 0.0;
            }
            dArray[i] = 1.0;
            dArray2 = matriz3.luBackSub(dArray);
            for (n2 = 0; n2 < n; ++n2) {
                dArray3[n2][i] = dArray2[n2];
            }
        }
        return matriz2;
    }

    public Matriz transpose() {
        Matriz matriz = new Matriz(this.ncol, this.nrow);
        double[][] dArray = matriz.getArrayReference();
        for (int i = 0; i < this.ncol; ++i) {
            for (int j = 0; j < this.nrow; ++j) {
                dArray[i][j] = this.matriz[j][i];
            }
        }
        return matriz;
    }

    public static Matriz transpose(Matriz matriz) {
        Matriz matriz2 = new Matriz(matriz.ncol, matriz.nrow);
        double[][] dArray = matriz2.getArrayReference();
        for (int i = 0; i < matriz.ncol; ++i) {
            for (int j = 0; j < matriz.nrow; ++j) {
                dArray[i][j] = matriz.matriz[j][i];
            }
        }
        return matriz2;
    }

    public Matriz opposite() {
        Matriz matriz = Matriz.copy(this);
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < this.ncol; ++j) {
                matriz.matriz[i][j] = -this.matriz[i][j];
            }
        }
        return matriz;
    }

    public static Matriz opposite(Matriz matriz) {
        Matriz matriz2 = Matriz.copy(matriz);
        for (int i = 0; i < matriz.nrow; ++i) {
            for (int j = 0; j < matriz.ncol; ++j) {
                matriz2.matriz[i][j] = -matriz.matriz[i][j];
            }
        }
        return matriz2;
    }

    public double trace() {
        double d = 0.0;
        for (int i = 0; i < Math.min(this.ncol, this.ncol); ++i) {
            d += this.matriz[i][i];
        }
        return d;
    }

    public static double trace(Matriz matriz) {
        double d = 0.0;
        for (int i = 0; i < Math.min(matriz.ncol, matriz.ncol); ++i) {
            d += matriz.matriz[i][i];
        }
        return d;
    }

    public double determinant() {
        int n = this.nrow;
        if (n != this.ncol) {
            throw new IllegalArgumentException("Matriz is not square");
        }
        double d = 0.0;
        Matriz matriz = this.luDecomp();
        d = matriz.dswap;
        for (int i = 0; i < n; ++i) {
            d *= matriz.matriz[i][i];
        }
        return d;
    }

    public static double determinant(Matriz matriz) {
        int n = matriz.nrow;
        if (n != matriz.ncol) {
            throw new IllegalArgumentException("Matriz is not square");
        }
        double d = 0.0;
        Matriz matriz2 = matriz.luDecomp();
        d = matriz2.dswap;
        for (int i = 0; i < n; ++i) {
            d *= matriz2.matriz[i][i];
        }
        return d;
    }

    public double logDeterminant() {
        int n = this.nrow;
        if (n != this.ncol) {
            throw new IllegalArgumentException("Matriz is not square");
        }
        double d = 0.0;
        Matriz matriz = this.luDecomp();
        d = matriz.dswap;
        d = Math.log(d);
        for (int i = 0; i < n; ++i) {
            d += Math.log(matriz.matriz[i][i]);
        }
        return d;
    }

    public static double logDeterminant(Matriz matriz) {
        int n = matriz.nrow;
        if (n != matriz.ncol) {
            throw new IllegalArgumentException("Matriz is not square");
        }
        double d = 0.0;
        Matriz matriz2 = matriz.luDecomp();
        d = matriz2.dswap;
        d = Math.log(d);
        for (int i = 0; i < n; ++i) {
            d += Math.log(matriz2.matriz[i][i]);
        }
        return d;
    }

    public double frobeniusNorm() {
        double d = 0.0;
        for (int i = 0; i < this.nrow; ++i) {
            for (int j = 0; j < this.ncol; ++j) {
                d = Matriz.hypot(d, Math.abs(this.matriz[i][j]));
            }
        }
        return d;
    }

    public double oneNorm() {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.nrow; ++i) {
            d2 = 0.0;
            for (int j = 0; j < this.ncol; ++j) {
                d2 += Math.abs(this.matriz[j][i]);
            }
            d = Math.max(d, d2);
        }
        return d;
    }

    public double infinityNorm() {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.ncol; ++i) {
            d2 = 0.0;
            for (int j = 0; j < this.nrow; ++j) {
                d2 += Math.abs(this.matriz[i][j]);
            }
            d = Math.max(d, d2);
        }
        return d;
    }

    public Matriz luDecomp() {
        int n;
        int n2;
        if (this.nrow != this.ncol) {
            throw new IllegalArgumentException("A matrix is not square");
        }
        int n3 = this.nrow;
        int n4 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double[] dArray = new double[n3];
        double d4 = 0.0;
        double d5 = 0.0;
        this.matrizCheck = true;
        Matriz matriz = Matriz.copy(this);
        double[][] dArray2 = matriz.getArrayReference();
        matriz.dswap = 1.0;
        for (n2 = 0; n2 < n3; ++n2) {
            d3 = 0.0;
            for (n = 0; n < n3; ++n) {
                double d6;
                d2 = Math.abs(dArray2[n2][n]);
                if (!(d6 > d3)) continue;
                d3 = d2;
            }
            if (d3 == 0.0) {
                System.out.println("Attempted LU Decomposition of a singular matrix in Matriz.luDecomp()");
                System.out.println("NaN matrix returned and matrixCheck set to false");
                this.matrizCheck = false;
                for (n = 0; n < n3; ++n) {
                    for (int i = 0; i < n3; ++i) {
                        dArray2[n][i] = Double.NaN;
                    }
                }
                return matriz;
            }
            dArray[n2] = 1.0 / d3;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            int n5;
            for (n = 0; n < n2; ++n) {
                d4 = dArray2[n][n2];
                for (n5 = 0; n5 < n; ++n5) {
                    d4 -= dArray2[n][n5] * dArray2[n5][n2];
                }
                dArray2[n][n2] = d4;
            }
            d3 = 0.0;
            for (n = n2; n < n3; ++n) {
                double d7;
                d4 = dArray2[n][n2];
                for (n5 = 0; n5 < n2; ++n5) {
                    d4 -= dArray2[n][n5] * dArray2[n5][n2];
                }
                dArray2[n][n2] = d4;
                d = dArray[n] * Math.abs(d4);
                if (!(d7 >= d3)) continue;
                d3 = d;
                n4 = n;
            }
            if (n2 != n4) {
                for (n = 0; n < n3; ++n) {
                    d5 = dArray2[n4][n];
                    dArray2[n4][n] = dArray2[n2][n];
                    dArray2[n2][n] = d5;
                }
                matriz.dswap = -matriz.dswap;
                dArray[n4] = dArray[n2];
            }
            matriz.index[n2] = n4;
            if (dArray2[n2][n2] == 0.0) {
                dArray2[n2][n2] = 1.0E-30;
            }
            if (n2 == n3 - 1) continue;
            d5 = 1.0 / dArray2[n2][n2];
            for (n = n2 + 1; n < n3; ++n) {
                double[] dArray3 = dArray2[n];
                int n6 = n2;
                dArray3[n6] = dArray3[n6] * d5;
            }
        }
        return matriz;
    }

    public double[] luBackSub(double[] dArray) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = dArray.length;
        if (n5 != this.ncol) {
            throw new IllegalArgumentException("vector length is not equal to matrix dimension");
        }
        if (this.ncol != this.nrow) {
            throw new IllegalArgumentException("matrix is not square");
        }
        double d = 0.0;
        double[] dArray2 = new double[n5];
        for (n2 = 0; n2 < n5; ++n2) {
            dArray2[n2] = dArray[n2];
        }
        for (n2 = 0; n2 < n5; ++n2) {
            n4 = this.index[n2];
            d = dArray2[n4];
            dArray2[n4] = dArray2[n2];
            if (n3 == 0) {
                for (n = n3; n <= n2 - 1; ++n) {
                    d -= this.matriz[n2][n] * dArray2[n];
                }
            } else if (d == 0.0) {
                n3 = n2;
            }
            dArray2[n2] = d;
        }
        for (n2 = n5 - 1; n2 >= 0; --n2) {
            d = dArray2[n2];
            for (n = n2 + 1; n < n5; ++n) {
                d -= this.matriz[n2][n] * dArray2[n];
            }
            dArray2[n2] = d / this.matriz[n2][n2];
        }
        return dArray2;
    }

    public double[] solveLinearSet(double[] dArray) {
        Matriz matriz = this.luDecomp();
        return matriz.luBackSub(dArray);
    }

    private static double hypot(double d, double d2) {
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = Math.abs(d);
        double d6 = Math.abs(d2);
        if (d5 == 0.0) {
            d3 = d6;
        } else if (d6 == 0.0) {
            d3 = d5;
        } else if (d5 <= d6) {
            d4 = d5 / d6;
            d3 = d6 * Math.sqrt(1.0 + d4 * d4);
        } else {
            d4 = d6 / d5;
            d3 = d5 * Math.sqrt(1.0 + d4 * d4);
        }
        return d3;
    }

    public Matriz autoValores() {
        int n;
        int n2;
        int n3 = this.nrow;
        int n4 = this.ncol;
        if (n3 != n4) {
            throw new IllegalArgumentException("autoValores: A matriz n\u00e3o \u00e9 quadrada.");
        }
        Matriz matriz = new Matriz(n3 + 1, n4);
        this.eigen = matriz.getArrayReference();
        matriz.nrow = n3 + 1;
        matriz.ncol = n4;
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        double[] dArray3 = new double[n3];
        double[][] dArray4 = new double[n3][n4];
        double[][] dArray5 = new double[n3][n4];
        dArray5 = this.getArrayCopy();
        int n5 = n4;
        for (n2 = 1; n2 <= n5; ++n2) {
            for (n = 1; n <= n5; ++n) {
                dArray4[n2 - 1][n - 1] = 0.0;
            }
            dArray4[n2 - 1][n2 - 1] = 1.0;
        }
        for (n2 = 1; n2 <= n5; ++n2) {
            dArray2[n2 - 1] = dArray5[n2 - 1][n2 - 1];
            dArray[n2 - 1] = dArray5[n2 - 1][n2 - 1];
            dArray3[n2 - 1] = 0.0;
        }
        int n6 = 0;
        for (int i = 1; i < 50; ++i) {
            double d = 0.0;
            for (n2 = 1; n2 <= n5 - 1; ++n2) {
                for (n = n2 + 1; n <= n5; ++n) {
                    d += Math.abs(dArray5[n2 - 1][n - 1]);
                }
            }
            if (d == 0.0) {
                int n7;
                for (n7 = 0; n7 < n5; ++n7) {
                    this.eigen[0][n7] = dArray[n7];
                }
                for (n7 = 0; n7 < n5; ++n7) {
                    for (int j = 0; j < n5; ++j) {
                        this.eigen[n7 + 1][j] = dArray4[n7][j];
                    }
                }
                return matriz;
            }
            double d2 = i < 4 ? 0.2 * d / (double)(n5 * n5) : 0.0;
            for (n2 = 1; n2 <= n5 - 1; ++n2) {
                for (n = n2 + 1; n <= n5; ++n) {
                    double d3 = 100.0 * Math.abs(dArray5[n2 - 1][n - 1]);
                    if (i > 4 && Math.abs(dArray[n2 - 1]) + d3 == Math.abs(dArray[n2 - 1]) && Math.abs(dArray[n - 1]) + d3 == Math.abs(dArray[n - 1])) {
                        dArray5[n2 - 1][n - 1] = 0.0;
                    } else if (Math.abs(dArray5[n2 - 1][n - 1]) > d2) {
                        int n8;
                        double d4;
                        double d5 = dArray[n - 1] - dArray[n2 - 1];
                        if (Math.abs(d5) + d3 == Math.abs(d5)) {
                            d4 = dArray5[n2 - 1][n - 1] / d5;
                        } else {
                            double d6 = 0.5 * d5 / dArray5[n2 - 1][n - 1];
                            d4 = 1.0 / (Math.abs(d6) + Math.sqrt(1.0 + d6 * d6));
                            if (d6 < 0.0) {
                                d4 = -d4;
                            }
                        }
                        double d7 = 1.0 / Math.sqrt(1.0 + d4 * d4);
                        double d8 = d4 * d7;
                        double d9 = d8 / (1.0 + d7);
                        d5 = d4 * dArray5[n2 - 1][n - 1];
                        dArray3[n2 - 1] = dArray3[n2 - 1] - d5;
                        dArray3[n - 1] = dArray3[n - 1] + d5;
                        dArray[n2 - 1] = dArray[n2 - 1] - d5;
                        dArray[n - 1] = dArray[n - 1] + d5;
                        dArray5[n2 - 1][n - 1] = 0.0;
                        for (n8 = 1; n8 <= n2 - 1; ++n8) {
                            d3 = dArray5[n8 - 1][n2 - 1];
                            d5 = dArray5[n8 - 1][n - 1];
                            dArray5[n8 - 1][n2 - 1] = d3 - d8 * (d5 + d3 * d9);
                            dArray5[n8 - 1][n - 1] = d5 + d8 * (d3 - d5 * d9);
                        }
                        for (n8 = n2 + 1; n8 <= n - 1; ++n8) {
                            d3 = dArray5[n2 - 1][n8 - 1];
                            d5 = dArray5[n8 - 1][n - 1];
                            dArray5[n2 - 1][n8 - 1] = d3 - d8 * (d5 + d3 * d9);
                            dArray5[n8 - 1][n - 1] = d5 + d8 * (d3 - d5 * d9);
                        }
                        for (n8 = n + 1; n8 <= n5; ++n8) {
                            d3 = dArray5[n2 - 1][n8 - 1];
                            d5 = dArray5[n - 1][n8 - 1];
                            dArray5[n2 - 1][n8 - 1] = d3 - d8 * (d5 + d3 * d9);
                            dArray5[n - 1][n8 - 1] = d5 + d8 * (d3 - d5 * d9);
                        }
                        for (n8 = 1; n8 <= n5; ++n8) {
                            d3 = dArray4[n8 - 1][n2 - 1];
                            d5 = dArray4[n8 - 1][n - 1];
                            dArray4[n8 - 1][n2 - 1] = d3 - d8 * (d5 + d3 * d9);
                            dArray4[n8 - 1][n - 1] = d5 + d8 * (d3 - d5 * d9);
                        }
                    }
                    ++n6;
                }
            }
            for (n2 = 1; n2 <= n5; ++n2) {
                dArray2[n2 - 1] = dArray2[n2 - 1] + dArray3[n2 - 1];
                dArray[n2 - 1] = dArray2[n2 - 1];
                dArray3[n2 - 1] = 0.0;
            }
        }
        System.out.println("eigenValue: Muitas itera\u00e7\u00f5es na rotina Jacobi.");
        return null;
    }

    public Matriz retornaValores() {
        int n = this.nrow - 1;
        int n2 = this.ncol;
        double[][] dArray = new double[n][1];
        double[][] dArray2 = new double[n + 1][n2];
        dArray2 = this.getArrayCopy();
        Matriz matriz = new Matriz(dArray);
        for (int i = 0; i < n; ++i) {
            dArray[i][0] = dArray2[0][i];
        }
        return matriz;
    }

    public Matriz retornaVetores() {
        int n = this.nrow - 1;
        int n2 = this.ncol;
        double[][] dArray = new double[n][n2];
        double[][] dArray2 = new double[n + 1][n2];
        dArray2 = this.getArrayCopy();
        Matriz matriz = new Matriz(dArray);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = dArray2[i + 1][j];
            }
        }
        return matriz;
    }

    public void imprimeMatriz() {
        String string = "#.###";
        DecimalFormat decimalFormat = null;
        decimalFormat = new DecimalFormat(string);
        if (this.matriz == null) {
            System.out.println("Matriz vazia.");
        } else {
            int n = this.getNrow();
            int n2 = this.getNcol();
            double[][] dArray = this.getArrayReference();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    String string2 = decimalFormat.format(dArray[i][j]);
                    System.out.print(string2 + "\t");
                }
                System.out.println();
            }
        }
    }

    public void imprimeMatrizInferior() {
        String string = "#.###";
        DecimalFormat decimalFormat = null;
        decimalFormat = new DecimalFormat(string);
        if (this.nrow != this.ncol) {
            throw new IllegalArgumentException("Array dimensions do not agree");
        }
        if (this == null) {
            System.out.println("Matriz vazia.");
        } else {
            int n = this.getNrow();
            int n2 = this.getNcol();
            double[][] dArray = this.getArrayReference();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    if (i < j) continue;
                    String string2 = decimalFormat.format(dArray[i][j]);
                    System.out.print(string2 + "\t");
                }
                System.out.println();
            }
        }
    }

    public void imprimeTransposta() {
        String string = "#.###";
        DecimalFormat decimalFormat = null;
        decimalFormat = new DecimalFormat(string);
        if (this.matriz == null) {
            System.out.println("Matriz vazia.");
        } else {
            int n = this.getNrow();
            int n2 = this.getNcol();
            double[][] dArray = this.getArrayReference();
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    String string2 = decimalFormat.format(dArray[j][i]);
                    System.out.print(string2 + "\t");
                }
                System.out.println();
            }
        }
    }

    public int[] ordenaAutoValores() {
        int n;
        double[][] dArray = this.getArrayReference();
        int n2 = 0;
        int n3 = this.getNrow();
        int[] nArray = new int[n3];
        double[] dArray2 = new double[n3];
        for (int i = 0; i < n3; ++i) {
            dArray2[i] = this.getElement(i, 0);
        }
        Arrays.sort(dArray2);
        int n4 = n3 - 1;
        for (n = 0; n < n4 / 2; ++n) {
            double d = dArray2[n];
            dArray2[n] = dArray2[n4 - n];
            dArray2[n4 - n] = d;
        }
        for (n = 0; n < n3; ++n) {
            while (dArray2[n] != this.getElement(n2, 0)) {
                ++n2;
            }
            nArray[n] = n2;
            n2 = 0;
        }
        for (n = 0; n < n3; ++n) {
            dArray[n][0] = dArray2[n];
        }
        return nArray;
    }

    public void ordenaAutoVetores(int[] nArray) {
        int n;
        int n2;
        double[][] dArray = this.getArrayReference();
        int n3 = this.getNrow();
        double[][] dArray2 = new double[n3][n3];
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                dArray2[n][n2] = dArray[n][nArray[n2]];
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                dArray[n][n2] = dArray2[n][n2];
            }
        }
    }

    public double[] porcentagemVariancia() {
        int n;
        double[][] dArray = this.getArrayReference();
        double d = 0.0;
        int n2 = this.getNrow();
        double[] dArray2 = new double[n2];
        for (n = 0; n < n2; ++n) {
            d += dArray[n][0];
        }
        for (n = 0; n < n2; ++n) {
            dArray2[n] = dArray[n][0] * 100.0 / d;
        }
        return dArray2;
    }

    public void correlacaoComponentePrincipal(double[] dArray, Matriz matriz, Matriz matriz2) {
        double[][] dArray2 = this.getArrayReference();
        double[][] dArray3 = matriz.getArrayCopy();
        double[][] dArray4 = matriz2.getArrayCopy();
        int n = this.getNrow();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray2[i][j] = dArray4[i][j] * Math.sqrt(dArray3[j][0]) / Math.sqrt(dArray[i]);
            }
        }
    }

    public void normaliza() {
        int n = this.getNrow();
        int n2 = this.getNcol();
        for (int i = 0; i < n2; ++i) {
            int n3;
            double d = 0.0;
            double d2 = 0.0;
            for (n3 = 0; n3 < n; ++n3) {
                double d3 = this.getElement(n3, i);
                d += d3;
                d2 += d3 * d3;
            }
            double d4 = d / (double)n;
            double d5 = Math.sqrt(((double)n - 1.0) / (d2 - d * d4));
            for (n3 = 0; n3 < n; ++n3) {
                this.setElement(n3, i, d5 * (this.getElement(n3, i) - d4));
            }
        }
    }

    public Matriz distEuclidiana() {
        double d = 0.0;
        int n = this.nrow;
        int n2 = this.ncol;
        Matriz matriz = new Matriz(n, n);
        double[][] dArray = matriz.getArrayReference();
        matriz.nrow = n;
        matriz.ncol = n;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < n2; ++k) {
                    double d2 = this.matriz[i][k] - this.matriz[j][k];
                    d += d2 * d2;
                }
                dArray[i][j] = Math.sqrt(d);
                d = 0.0;
            }
        }
        return matriz;
    }

    public Matriz distEuclidianaPonderada() {
        int n;
        int n2;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n3 = this.nrow;
        int n4 = this.ncol;
        double[] dArray = new double[this.ncol];
        Matriz matriz = new Matriz(n3, n3);
        double[][] dArray2 = matriz.getArrayReference();
        matriz.nrow = n3;
        matriz.ncol = n3;
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < n3; ++n) {
                d2 = this.matriz[n][n2];
                d4 += d2 * d2;
                d3 += d2;
            }
            dArray[n2] = 1.0 / (double)(n3 - 1) * (d4 - d3 * d3 / (double)n3);
            d4 = 0.0;
            d3 = 0.0;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                for (int i = 0; i < n4; ++i) {
                    d2 = this.matriz[n2][i] - this.matriz[n][i];
                    d += 1.0 / dArray[i] * d2 * d2;
                }
                dArray2[n2][n] = Math.sqrt(d);
                d = 0.0;
            }
        }
        return matriz;
    }
}

