/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.ImagemPainel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.basic.BasicArrowButton;

public class PainelControle
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private BasicArrowButton moveNoroeste;
    private BasicArrowButton moveNorte;
    private BasicArrowButton moveNordeste;
    private BasicArrowButton moveOeste;
    private BasicArrowButton moveCentro;
    private BasicArrowButton moveLeste;
    private BasicArrowButton moveSudoeste;
    private BasicArrowButton moveSul;
    private BasicArrowButton moveSudeste;
    private BasicArrowButton diminuiGrupos;
    private BasicArrowButton aumentaGrupos;
    private JButton btClassifica;
    private JFormattedTextField gruposTextField;
    private ImagemPainel imagemPainel;
    private ButtonGroup groupRadio;
    private JPanel painelCursor;
    private int nGrupos = 4;
    private int maxGrupos = 7;
    private int minGrupos = 4;
    private String[] cores = new String[]{"Vermelho", "Verde", "Azul", "Rosa", "Turquesa", "Amarelo", "Violeta"};
    private int[][] corGrupos = new int[][]{{255, 0, 0}, {0, 255, 0}, {0, 0, 255}, {255, 0, 255}, {0, 255, 255}, {255, 255, 0}, {128, 0, 255}, {102, 45, 17}, {102, 17, 85}};

    public PainelControle() {
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        this.painelCursor = new JPanel(new GridLayout(3, 4));
        this.groupRadio = new ButtonGroup();
        this.criaRadioBottons();
        this.painelCursor.setBorder(new TitledBorder(" Ferrugem: "));
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        this.gruposTextField = new JFormattedTextField((Object)50);
        this.gruposTextField.setValue(new Integer(this.nGrupos));
        this.gruposTextField.setColumns(2);
        this.gruposTextField.addPropertyChangeListener("value", this);
        this.gruposTextField.setEditable(false);
        JLabel jLabel = new JLabel("Grupos: ");
        this.btClassifica = new JButton("Classificar");
        this.btClassifica.addActionListener(this);
        this.diminuiGrupos = new BasicArrowButton(7);
        this.diminuiGrupos.addActionListener(this);
        this.aumentaGrupos = new BasicArrowButton(3);
        this.aumentaGrupos.addActionListener(this);
        jPanel2.add(jLabel);
        jPanel2.add(this.diminuiGrupos);
        jPanel2.add(this.gruposTextField);
        jPanel2.add(this.aumentaGrupos);
        jPanel2.add(this.btClassifica);
        jPanel2.setBorder(new TitledBorder(" Identifica\u00e7\u00e3o: "));
        this.setLayout(new GridLayout(0, 2));
        this.add(jPanel2);
        this.add(this.painelCursor);
    }

    public void atribuiPainelDeImagem(ImagemPainel imagemPainel) {
        this.imagemPainel = imagemPainel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.moveNoroeste)) {
            this.imagemPainel.moveAmostra(-1, -1);
        } else if (actionEvent.getSource().equals(this.moveNorte)) {
            this.imagemPainel.moveAmostra(0, -1);
        } else if (actionEvent.getSource().equals(this.moveNordeste)) {
            this.imagemPainel.moveAmostra(1, -1);
        } else if (actionEvent.getSource().equals(this.moveOeste)) {
            this.imagemPainel.moveAmostra(-1, 0);
        } else if (actionEvent.getSource().equals(this.moveLeste)) {
            this.imagemPainel.moveAmostra(1, 0);
        } else if (actionEvent.getSource().equals(this.moveSudoeste)) {
            this.imagemPainel.moveAmostra(-1, 1);
        } else if (actionEvent.getSource().equals(this.moveSul)) {
            this.imagemPainel.moveAmostra(0, 1);
        } else if (actionEvent.getSource().equals(this.moveSudeste)) {
            this.imagemPainel.moveAmostra(1, 1);
        } else if (actionEvent.getSource().equals(this.aumentaGrupos)) {
            if (this.nGrupos < this.maxGrupos) {
                ++this.nGrupos;
                this.gruposTextField.setValue(new Integer(this.nGrupos));
            }
        } else if (actionEvent.getSource().equals(this.diminuiGrupos)) {
            if (this.nGrupos > this.minGrupos) {
                --this.nGrupos;
                this.gruposTextField.setValue(new Integer(this.nGrupos));
            }
        } else if (actionEvent.getSource().equals(this.btClassifica)) {
            this.imagemPainel.calculaKmedias(this.nGrupos);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        if (object == this.gruposTextField) {
            int n = ((Number)this.gruposTextField.getValue()).intValue();
        }
    }

    public void criaRadioBottons() {
        GrupoItemListener grupoItemListener = new GrupoItemListener();
        for (int i = 0; i < this.maxGrupos; ++i) {
            int n = this.corGrupos[i][0];
            int n2 = this.corGrupos[i][1];
            int n3 = this.corGrupos[i][2];
            JCheckBox jCheckBox = new JCheckBox(this.cores[i]);
            jCheckBox.addItemListener(grupoItemListener);
            this.painelCursor.add(jCheckBox);
        }
    }

    public int retornaBotomSelecionado() {
        Enumeration<AbstractButton> enumeration = this.groupRadio.getElements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            JCheckBox jCheckBox = (JCheckBox)enumeration.nextElement();
            if (jCheckBox.isSelected()) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public class GrupoItemListener
    implements ItemListener {
        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            int[] nArray = new int[7];
            Component[] componentArray = PainelControle.this.painelCursor.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                JCheckBox jCheckBox = (JCheckBox)componentArray[i];
                nArray[i] = jCheckBox.isSelected() ? 1 : 0;
            }
            PainelControle.this.imagemPainel.mostraClusterSelecionado(nArray);
        }
    }

    public class GrupoItemListener2
    implements ItemListener {
        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            boolean bl = itemEvent.getStateChange() == 1;
            AbstractButton abstractButton = (AbstractButton)itemEvent.getItemSelectable();
            int n = PainelControle.this.retornaBotomSelecionado();
            if (n >= 0) {
                int n2 = PainelControle.this.corGrupos[n][0];
                int n3 = PainelControle.this.corGrupos[n][1];
                int n4 = PainelControle.this.corGrupos[n][2];
            }
        }
    }
}

