/***********************************************************************************
Amostra.java

Direitos Autorais Reservados (c) 2008 Embrapa Informtica Agropecuria

Este programa  software livre; voc pode redistribu-lo e/ou modific-lo sob os
termos da Licena Pblica Geral GNU conforme publicada pela Free Software
Foundation; tanto a verso 2 da Licena, como (a seu critrio) qualquer verso
posterior.

Este programa  distribudo na expectativa de que seja til, porm, SEM NENHUMA
GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU ADEQUAO A UMA
FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral do GNU para mais detalhes.

Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto com este
programa; se no, escreva para a Free Software Foundation, Inc., no endereo 59
Temple Street, Suite 330, Boston, MA 02111-1307 USA.

**********************************************************************************

Parte integrante do software LIVIA

Descrio:

    Implementa a classe Amostra que armazena os dados referentes a geometria da 
    regio de interesse.

Desenvolvido por:

    Joo Camargo Neto & Jos Iguelmar Miranda

Informaes do CVS:
       $Source$:
       $Revision$:
       $Date$:

***********************************************************************************/

package classes;

import java.util.Vector;

import java.awt.Point;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;

public class Amostra {
	public Vector pontosBorda;
	// Representa a rea vlida para processamento com valor 1
	public int[][] amostraMascara;         
	private int xCentro, yCentro;
	private int raio;
	// Usado para gerar mscara e checar se um ponto pertence  amostra
	public GeneralPath amostraGP;		
	// Armazena o retangulo mnimo envolvente
	public int xMin;								
	public int yMin;
	public int xMax;
	public int yMax;
	public int largura;
	public int altura;
	private Color corBorda = Color.blue;
	private Color corPontos = Color.green;
	private int nPontosBorda;
	
	// CONSTRUTOR DA CLASSE
	public Amostra(double x, double y, double r, int nP){
		nPontosBorda = nP;
		pontosBorda = new Vector();
		amostraGP = new GeneralPath();
		xCentro = Math.round((float) x);
		yCentro = Math.round((float) y);
		raio = Math.round((float) r);
		calculaPontosBorda();
		calculaParametros();
		criaMascara();
	}

	// MTODOS PBLICOS

	public int retornaXOrigem(){
		return xMin;
	}
	public int retornaYOrigem(){
		return yMin;
	}

	public int retornaLargura(){
		return largura;
	}
	public int retornaAltura(){
		return altura;
	}

	public GeneralPath retornaGP(){
		return amostraGP;
	}

	public int[][] retornaMascara(){
		return amostraMascara;
	}
	
	public int [][] adicionaMoldura(int[][] vec, int borda){
		int[][] vecTmp;
		int w = vec.length;
		int h = vec[0].length;

		vecTmp = new int[w+2*borda][h+2*borda];
		for (int i = 0; i < h; i++) {
			for (int j = 0; j < w; j++) {
				vecTmp[j+borda][i+borda] = vec[j][i];									
			}
		}
		return vecTmp;

	}

	// Retira os pixes da moldura
	public int [][] removerMoldura(int [][] vec, int bordaTalhao){
		int [][] vecTmp;
		int w = vec.length-2*bordaTalhao;
		int h = vec[0].length-2*bordaTalhao;

		vecTmp = new int[w][h];
		for (int i = 0; i < h; i++) {
			for (int j = 0; j < w; j++) {
				vecTmp[j][i] = vec[j+bordaTalhao][i+bordaTalhao];									
			}
		}
		return vecTmp;
	}

	public void desenhaBorda(Graphics2D g2D) {
		int n, x1, y1;
		Point pt;
		Ellipse2D elipse = new Ellipse2D.Float();	
		
		g2D.setColor(corPontos);
		n = pontosBorda.size();	
		for (int i = 0; i < n ; i++){
			pt = (Point) pontosBorda.get(i);	
			x1 = pt.x;
			y1 = pt.y;
			elipse.setFrame(x1-4, y1-4, 9, 9);
			g2D.fill(elipse);
		}
		g2D.setColor(corBorda);
		g2D.draw(amostraGP);
	}

	public void atribuiCorBorda(Color cB){
		corBorda = cB;
	}

	public void atribuiCorPontos(Color cP){
		corPontos = cP;
	}

	public void move(int dx, int dy){
		Point pt;
		int x, y;
		int n = pontosBorda.size();
		for (int i = 0; i < n; i++) {
			pt = (Point)pontosBorda.get(i);
			pt.setLocation(pt.x+dx, pt.y+dy);
		}
		amostraGP.reset();
		calculaParametros();
		amostraMascara = null;
		criaMascara();
	}

	// retorna o indice do ponto da borda escolhido 
	public int achaPontoBorda(int x, int y){
		Point pt;
		int ind = -1;
		int n = pontosBorda.size();
		for(int i = 0; i < n; i++){
			pt = (Point)pontosBorda.get(i);
			if((Math.abs(pt.x-x) < 10) && (Math.abs(pt.y-y) < 10)){
				ind = i;
				break;
			}	
		}
		return ind;
	}

	public void atualizaPontoBorda(int ind, int x, int y){
		Point pt;
		pt = (Point)pontosBorda.get(ind);
		pt.setLocation(x, y);
		amostraGP.reset();
		calculaParametros();
		amostraMascara = null;
		criaMascara();
	}

	// MTODOS PRIVADOS
	private void calculaPontosBorda(){
		int x, y;
		double angDeg = 360/nPontosBorda;
		double angRad;
		
		for(int i=0; i < nPontosBorda; i++){
			angRad = Math.toRadians(i*angDeg);
			x = Math.round((float) (xCentro + raio*Math.cos(angRad)));
			y = Math.round((float) (yCentro + raio*Math.sin(angRad)));
			pontosBorda.addElement(new Point(x,y));
		}
	}

	// Calcula xMax, yMax, xMin, yMin, largura, altura, amostra general Path
	private void calculaParametros(){
		int i, n;
		float[] x1 = null;
		float[] y1 = null;
		Point pt;

		n = pontosBorda.size();
		x1 = new float[n];
		y1 = new float[n];
		pt = (Point)pontosBorda.get(0);
		xMin = pt.x; xMax = pt.x;
		yMin = pt.y; yMax = pt.y;
		for (i = 0; i < n; i++) {
				pt = (Point)pontosBorda.get(i);
				x1[i] = pt.x;
				y1[i] = pt.y;
				xMin = (int)Math.min(xMin, x1[i]);
				yMin = (int)Math.min(yMin, y1[i]);
				xMax = (int)Math.max(xMax, x1[i]);
				yMax = (int)Math.max(yMax, y1[i]);
		}

		largura = xMax - xMin + 1;
		altura = yMax - yMin + 1;

		// Cria general path	
		amostraGP.moveTo(x1[0], y1[0]);
		for (i = 1; i < n; i++)
			amostraGP.lineTo(x1[i], y1[i]);
		amostraGP.closePath();
	}

	// Cria mscara contendo valor 1 na regio de interesse e zero fora.
	private void criaMascara(){
		int i, j, n;
		int lin, col;

	  // Aloca espao para o vetor mscara com as bordas
		amostraMascara = new int[largura][altura];
		// Atribui 0 (zero) a todos os pontos da mscara
		for (i = 0; i < altura; i++){
			for (j = 0; j < largura; j++){
				amostraMascara[j][i] = 0;
			}
		}
		// Atribui valor 1 a todos os pontos pertencentes ao ROI na mscara
		lin = 0;
		for (i = yMin; i <= yMax; i++) {
			col = 0;
			for (j = xMin; j <= xMax; j++) {
				if (amostraGP.contains((double)j, (double)i)) {
					amostraMascara[col][lin] = 1;								
				}
				col++;					
			}
			lin++;
		}
	}
}
