/***********************************************************************************
Cluster.java

Direitos Autorais Reservados (c) 2008 Embrapa Informtica Agropecuria

Este programa  software livre; voc pode redistribu-lo e/ou modific-lo sob os
termos da Licena Pblica Geral GNU conforme publicada pela Free Software
Foundation; tanto a verso 2 da Licena, como (a seu critrio) qualquer verso
posterior.

Este programa  distribudo na expectativa de que seja til, porm, SEM NENHUMA
GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU ADEQUAO A UMA
FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral do GNU para mais detalhes.

Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto com este
programa; se no, escreva para a Free Software Foundation, Inc., no endereo 59
Temple Street, Suite 330, Boston, MA 02111-1307 USA.

**********************************************************************************

Parte integrante do software LIVIA

Descrio:

    Classe que implementa o algoritmo k-mdias

Parmetros de entrada:

  Uma matriz de inteiros com os pixels a serem classificados

Sada:

  Painel com a imagem original e imagem binria.

Desenvolvido por:

    Jos Iguelmar Miranda 
    Referencia:
      Helmuth Spaeth,
			Cluster Analysis Algorithms
			  for Data Reduction and Classification of Objects,
			  Ellis Horwood, 1980, page 72-74.

Informaes do CVS:
       $Source$:
       $Revision$:
       $Date$:

***********************************************************************************/

package classes;

public class Cluster {

	// CONSTRUTOR
	// O construtor  responsvel por definir o nmero de grupos

	public Cluster() {
  }

	// MTODOS PBLICOS
	
	// Mtodo para array int
	public int[] kMeans(int[][] X, int[] grupos, int nc, int idr) {
		int m = X.length;
		int n = X[0].length;
		int r, u, v = 0, w = 0, i, it;
		int[] q = new int[nc];
		double a, b, soma_sdQ, f, g, h, t = 0.0;
		double[] sdQ = new double[nc];
		double[][] centroide = new double[nc][n];
		boolean flag = true;

    if (m <= 0) {
			System.out.println("KMEANS - Fatal error!  M <= 0.");
			System.exit(0);
		}

    if (n <= 0) {
			System.out.println("KMEANS - Fatal error!  N <= 0.");
			System.exit(0);
		}

    if (nc <= 0) {
			System.out.println("KMEANS - Fatal error!  NC <= 0.");
			System.exit(0);
		}

    if ( nc > m ) {
			System.out.println("KMEANS - Fatal error!  NC > M.");
			System.exit(0);
		}
		/*
      Certifica que a atribuio dos grupos est ok.
		*/
		for (int ic = 0; ic < m; ic++) {
			if (grupos[ic] < 1 || grupos[ic] > nc) {
				return grupos;
			}
		}

		/*
      Se existe apenas um grupo, parar.
		*/
    if (nc == 1) {
			return grupos;
		}

		/*
      Determina a populao dos grupos.
		*/
		v = 0;
		w = 0;
		for (int j = 0; j < nc; j++) {
			q[j] = 0;
      sdQ[j] = 0.0;
			for (int k = 0; k < n; k++) {
				centroide[j][k] = 0.0;
			}
		}

		/*
      Conta o nmero de grupos vazios.
		*/
		for (int ic = 1; ic <= m; ic++) {
			r = grupos[ic-1];
      if (r < 1 || r > nc) {
				return grupos;
			}
      q[r-1]++;
			for (int k = 0; k < n; k++) {
				centroide[r-1][k] = centroide[r-1][k] + (double)X[ic-1][k];
			}
		}

		/*
      Determina o centride de cada grupo (mdia).
		*/
		for (int j = 0; j < nc; j++) {
			r = q[j];
      if (r == 0) {
				return grupos;
			}
      f = 1.0/(double)r;
			for (int k = 0; k < n; k++) {
				centroide[j][k] *= f;
			}
		}

		/*
      Determina a varincia dos grupos (Clculo da soma dos quadrados).
		*/
		for (int ic = 0; ic < m; ic++) {
			r = grupos[ic];
      f = 0.0;
			for (int k = 0; k < n; k++) {
				t = centroide[r-1][k] - (double)X[ic][k];
        f += t*t;
			}
      sdQ[r-1] += f;
			if (sdQ[r-1] < 0)	{
				System.out.println("sdQ["+(r-1)+"] = "+sdQ[r-1]);
			}
		}
    soma_sdQ = 0.0;
		for (int j = 0; j < nc; j++) {
			soma_sdQ += sdQ[j];
		}

		/*
      Se todos os pontos foram examinados sem mudanas, finalizar.
		*/
		i = -1;
		it = 0;
		do {
	    i++;
      if (i > m - 1)
         i -= m;
      if (it == m - 1) {
				return grupos;
			}
      r = grupos[i];
      u = q[r-1];
      if (u > 1) {
				h = (double)u;
		    h /= (h - 1.0);
		    f = 0.0;
				for (int k = 0; k < n; k++) {
					t = centroide[r-1][k] - (double)X[i][k];
	        f += t*t;
				}
				a = h*f;
				b = 1.e30;
				for (int j = 0; j < nc; j++) {
					if (j != r-1) {
						u = q[j];
						h = (double)u;
						h /= (h + 1.0);
						f = 0.0;
						for (int k = 0; k < n; k++) {
							t = centroide[j][k] - (double)X[i][k];
						  f += t*t;
						}
						f = h*f;
						if (f <= b) {
							b = f;
							v = j + 1;
							w = u;
						} // if (f <= b)
					} // if (j != r)
				}
	      if (b >= a) {
		      it++;
				} else {
			    it = 0;
		      sdQ[r-1] -= a;
		      sdQ[v-1] += b;
		      soma_sdQ = (soma_sdQ - a) + b;
		      h = (double)(q[r-1]);
		      g = (double)w;
		      a = 1.0/(h - 1.0);
		      b = 1.0/(g + 1.0);
					for (int k = 0; k < n; k++) {
						f = (double)X[i][k];
						centroide[r-1][k] = (h*centroide[r-1][k] - f)*a;
            centroide[v-1][k] = (g*centroide[v-1][k] + f)*b;
					  f += t*t;
					}
		      grupos[i] = v;
		      q[r-1]--;
		      q[v-1]++;
				}		// else if (b >= a)
			}	// if (u > 1)
		}	while (flag);
		return grupos;
	}		// int KMeans
}
