/***********************************************************************************
Imagem.java

Direitos Autorais Reservados (c) 2008 Embrapa Informtica Agropecuria

Este programa  software livre; voc pode redistribu-lo e/ou modific-lo sob os
termos da Licena Pblica Geral GNU conforme publicada pela Free Software
Foundation; tanto a verso 2 da Licena, como (a seu critrio) qualquer verso
posterior.

Este programa  distribudo na expectativa de que seja til, porm, SEM NENHUMA
GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU ADEQUAO A UMA
FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral do GNU para mais detalhes.

Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto com este
programa; se no, escreva para a Free Software Foundation, Inc., no endereo 59
Temple Street, Suite 330, Boston, MA 02111-1307 USA.

**********************************************************************************

Parte integrante do software 'Processamento de Imagens Digitais'

Descrio:

  Define a classe principal para processamento de imagens digitais:
  o objetivo  tornar disponvel os pixels de um arquivo imagem no
  vetor "vetorPixels[][]"

Desenvolvido por:

    Jos Iguelmar Miranda

Informaes do CVS:
       $Source$:
       $Revision$:
       $Date$:

***********************************************************************************/

package classes;

import java.io.File;

// pacotes do AWT
import java.awt.image.WritableRaster;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;

// pacotes do Swing
import javax.swing.JFileChooser;

// leitura em modo imediato - para J2SE 1.4+
import javax.imageio.ImageIO;

public class Imagem {

	// ATRIBUTOS

	// Array de inteiros para armazenar os pixels da imagem. Na primeira dimenso 
  // esto as bandas e na segunda, os pixels de cada banda.
	private int vetorPixels[][];

	// Altura e largura da imagem
	private int altura, largura;

	// Nmero de bandas da imagem
	private int numBandas;

	// Mscara: 
	private int[][] maskPixels;

	// Arquivo imagem
	File arquivoImagem;

	// Nome do arquivo imagem
	private String nomeArquivoImagem;

	// Nome da BufferedImage
	BufferedImage biImagem = null;

	// CONSTRUTOR DA CLASSE
	//	L o arquivo imagem e disponibiliza os valores dos pixels no 
	//  array int[][] pixels
	public Imagem(){

		JFileChooser fileChooser = new JFileChooser();
		String curDir = System.getProperty("user.dir");
    String dir = curDir + "\\..\\imagens";
		fileChooser.setCurrentDirectory(new java.io.File(dir));
		fileChooser.setDialogTitle("Abre imagem");
    fileChooser.addChoosableFileFilter(new FiltrosImagem());
    fileChooser.setAcceptAllFileFilterUsed(false);
    int status = fileChooser.showOpenDialog(null);
    if (status == JFileChooser.APPROVE_OPTION) {
			arquivoImagem = fileChooser.getSelectedFile();
			abreImagem();
			altura = biImagem.getHeight();
			largura = biImagem.getWidth();
			matrizDePixels();
			System.out.println("Arquivo: " + arquivoImagem.getParent() 
														+ " --- " + arquivoImagem.getName());
			System.out.println("#bandas = " + numBandas);
		} else 
			if (status == JFileChooser.CANCEL_OPTION)
				arquivoImagem = null;
	}

	public Imagem(File file){
		arquivoImagem = file;
		abreImagem();
		altura = biImagem.getHeight();
		largura = biImagem.getWidth();
		matrizDePixels();
		System.out.println("Arquivo: " + arquivoImagem.getParent() 
									+ " --- " + arquivoImagem.getName());
		System.out.println("#bandas = " + numBandas);
	}

	public Imagem(int[][][] vetorPixels){
		numBandas =  vetorPixels.length;
		largura = vetorPixels[0].length;
		altura = vetorPixels[0][0].length;
		arquivoImagem = null;
		abreImagem(vetorPixels);
		matrizDePixels();
	}

	// MTODOS PBLICOS DA CLASSE

	// Retorna bandaa e vetor de pixels como coluna (uma varivel)
	public int[][] retornaVetorPixels() {
		return vetorPixels;
	}

	public int retornaLargura() {
		return largura;
	}	

	public int retornaAltura() {
		return altura;
	}	

	public int retornaBandas() {
		return numBandas;
	}
	public void atribuiMascara(int[][] mask) {
		maskPixels = mask;
	}
	public int[][] retornaMascara() {
		return maskPixels;
	}

	public BufferedImage retornaBI() {
		return biImagem;
	}

	public String retornaNomeArquivoImagem() {
		if (arquivoImagem != null) {
			nomeArquivoImagem = arquivoImagem.getName();
			return nomeArquivoImagem;
		} else
			return null;
	}	

	// MTODOS PRIVADOS DA CLASSE

	// Abre arquivo imagem
	private void abreImagem() {
		try {
			biImagem = ImageIO.read(arquivoImagem);
			numBandas = biImagem.getSampleModel().getNumBands();
	  } catch(Exception e) {
			biImagem = null;
	    System.out.println("Problema lendo '" + arquivoImagem + "'.");
	  }
	}

	private void abreImagem(int[][][] vetorPixels) {
		int tipo = BufferedImage.TYPE_3BYTE_BGR;
		biImagem = new BufferedImage(largura, altura, tipo);
		WritableRaster destWR1 = biImagem.getRaster();
				
		for (int i = 0; i < altura; i++)
			for (int j = 0; j < largura; j++) {
				destWR1.setSample(j, i, 0, vetorPixels[0][j][i]);
				destWR1.setSample(j, i, 1, vetorPixels[1][j][i]);
				destWR1.setSample(j, i, 2, vetorPixels[2][j][i]);
			}
	}

	// L os valores de pixels do arquivo imagem e os armazena numa matriz
	private void matrizDePixels() {

		int indice;
		Raster srcR = biImagem.getRaster();
		vetorPixels = new int[numBandas][largura*altura];

	    for (int i = 0; i < altura; i++)
			for (int j = 0; j < largura; j++) {
  				indice = i*largura + j;
				for (int nb = 0; nb < numBandas; nb++)
	  				vetorPixels[nb][indice] = srcR.getSample(j, i, nb);
			}
	}

}
