/***********************************************************************************
ImagemPainel.java

Direitos Autorais Reservados (c) 2008 Embrapa Informtica Agropecuria

Este programa  software livre; voc pode redistribu-lo e/ou modific-lo sob os
termos da Licena Pblica Geral GNU conforme publicada pela Free Software
Foundation; tanto a verso 2 da Licena, como (a seu critrio) qualquer verso
posterior.

Este programa  distribudo na expectativa de que seja til, porm, SEM NENHUMA
GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU ADEQUAO A UMA
FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral do GNU para mais detalhes.

Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto com este
programa; se no, escreva para a Free Software Foundation, Inc., no endereo 59
Temple Street, Suite 330, Boston, MA 02111-1307 USA.

**********************************************************************************

Parte integrante do software LIVIA

Descrio:

    Classe de painel para manipular as imagens.

Desenvolvido por:

 Embrapa Informtica Agropecuria
 Laboratrio de Processamento de Imagens

Informaes do CVS:
       $Source$:
       $Revision$:
       $Date$:

***********************************************************************************/

package classes;

// Pacotes genricos
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.BufferedWriter;
import java.util.Vector;

// Pacotes AWT
import java.awt.Image;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.Raster;
import java.awt.AlphaComposite;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.awt.geom.AffineTransform;

// ... AWT events
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.MouseMotionListener;

// Pacotes Swing
import javax.swing.JPanel;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class ImagemPainel extends JPanel 
													implements MouseListener, 
													MouseMotionListener, MouseWheelListener {

	// ATRIBUTOS
  private Image m_image;
	private Vector vetorAmostras;
	private Vector roi;
	private Graphics2D g2D;
	private BufferedImage imagemOriginal;
	private BufferedImage imagemBuckUp;
	private int numeroCluster = 0, nPontos = 0, indiceAmostra = -1, xAnt, yAnt,
							xAtual, yAtual, amostraPontos, indPonto = -1;
	private int[][] mascaraPlanta;
	private int[] grupos;
	private double m_zoomPercentage, m_zoom = 1.0, diamAmostra;
	private double[][] pontos = new double[3][2];
  private boolean zoomFlag = false;
	private boolean	flagUsaDiametro = false;
	private boolean flagMoveAmostra = true;
	private Amostra amostraSelecionada;
	private Imagem image;
	private static String nomeArquivo;
	  
  /**
    * Construtor
    *
    * @param Imagem
    * @param zoomPercentage
    * @param nPontos
  */
  public ImagemPainel(Imagem img, double zoomPercentage, int nPontos) {
		amostraPontos = nPontos;
		image = img;
		if (image.retornaNomeArquivoImagem() != null) {
			nomeArquivo = image.retornaNomeArquivoImagem();
		}	
		imagemOriginal = image.retornaBI();
		WritableRaster destWR = imagemOriginal.copyData(null); 
		imagemBuckUp = new BufferedImage(imagemOriginal.getColorModel(), destWR, false, null);
		amostraSelecionada = null;
		m_image = new ImageIcon(imagemOriginal).getImage();
		m_zoomPercentage = zoomPercentage / 100;
		addMouseListener(this);
		addMouseWheelListener(this);
		addMouseMotionListener(this);
		vetorAmostras = new Vector();
		roi = new Vector();
	}

  /**
    * Construtor
    *
    * @param 
    * @param zoomPercentage
  */
	public void atribuiImagem(Imagem img, double zoomPercentage,  int nPontos) {
		amostraPontos = nPontos;
		image = null;
		m_image = null;
		image = img;
		imagemBuckUp = null;
		imagemOriginal = image.retornaBI();
		WritableRaster destWR = imagemOriginal.copyData(null); 
		imagemBuckUp = new BufferedImage(imagemOriginal.getColorModel(), destWR, false, null);
		amostraSelecionada = null;
		m_image = new ImageIcon(imagemOriginal).getImage();
        m_zoomPercentage = zoomPercentage / 100;
		addMouseListener(this);
		addMouseWheelListener(this);
		addMouseMotionListener(this);
		vetorAmostras.removeAllElements();
		roi.removeAllElements();
  }

   // Libera alocao 
	public void limpa(){
		image = null;
	}

  /**
     * Sobreposio de mtodo para desenhar imagem
     *
  */
  public void paintComponent(Graphics grp) {
		Amostra aM;
    g2D = (Graphics2D)grp;		
		int x, y, N, n;

    x = y = 0;
    g2D.setColor(Color.LIGHT_GRAY);
    g2D.fillRect(0, 0, getWidth(), getHeight());
    g2D.scale(m_zoom, m_zoom);
    g2D.drawImage(m_image, 0, 0, this);
		n = vetorAmostras.size();
		for(int i = 0; i < n; i++){
			aM = (Amostra) vetorAmostras.get(i);
			aM.desenhaBorda(g2D);
		}		  
  }
    
  /**
     * Sobreposio de mtodo para desenhar imagem para retornar tamanho
		 * preferido da imagem
  */
  public Dimension getPreferredSize() {
		return new Dimension((int)(m_image.getWidth(this) +
                (m_image.getWidth(this) * (m_zoom - 1))),
                (int)(m_image.getHeight(this) +
                (m_image.getHeight(this) * (m_zoom -1 ))));
  }
    
  /**
     * Define porcentagem de zoom
     * @param zoomPercentage
  */
  public void setZoomPercentage(int zoomPercentage) {
		m_zoomPercentage = ((double)zoomPercentage) / 100;
  }
    
  /**
     * Redefine imagem para tamanho original
  */
  public void originalSize() {
		 m_zoom = 1;
     zoomFlag = true;
  }
    
  /**
     * Mtodo para incrementar zoom
  */
  public void zoomIn() {
    m_zoom += m_zoomPercentage;
    zoomFlag = true;
  }
    
  public void setZoom(double zoom) {
    m_zoom = zoom/100;
    zoomFlag = true;
  }
  
	/**
     *  Mtodo para decrementar zoom
  */
  public void zoomOut() {
    m_zoom -= m_zoomPercentage;
        
    if(m_zoom < m_zoomPercentage) {
      if(m_zoomPercentage > 1.0) {
         m_zoom = 1.0;
      } else {
         zoomIn();
			}
    }
      zoomFlag = true;
  }
    
  /**
     * Retorna a porcentagem atual de zoom
     *
     * @return m_zoom
  */
  public double getZoomedTo() {
    return m_zoom * 100;
  }

	/**
     * Manipula mouse
  */
	public void mouseDragged(MouseEvent e) {
		int dx, dy;

		if(amostraSelecionada != null){
			xAnt = xAtual;
			yAnt = yAtual;
			xAtual = e.getX();
			yAtual = e.getY();
			dx = xAtual - xAnt;
			dy = yAtual - yAnt;
			if(flagMoveAmostra)
				amostraSelecionada.move(dx, dy);
			else{
				if (indPonto >= 0){
					amostraSelecionada.atualizaPontoBorda(indPonto, xAtual, yAtual);
				}
			}
			repaint();
			}
  }

	// Mtodos da interface do mouse
	public void mouseMoved(MouseEvent e) { }

  public void mouseClicked(MouseEvent e) { }

  public void mouseEntered(MouseEvent e) { }
           
  public void mouseExited(MouseEvent e) { }
           
  public void mousePressed(MouseEvent e) {

		xAtual = e.getX();
		yAtual = e.getY();
		indPonto = -1;
		Amostra amostra = retornaAmostra(xAtual, yAtual);
		if(amostra != null){
			if(amostraSelecionada != amostra){ // seleciona nova amostra	
				selecionaAmostra(amostra);
				nPontos = 0;
			} else {
				indPonto = amostraSelecionada.achaPontoBorda(xAtual, yAtual);
				if(indPonto >= 0)
					flagMoveAmostra = false; // move ponto
				else
					flagMoveAmostra = true; // move amostra
				}
		} else {
			if(amostraSelecionada != null){
				indPonto = amostraSelecionada.achaPontoBorda(xAtual, yAtual);
				if(indPonto >= 0)
					flagMoveAmostra = false; // move ponto
				else {
					selecionaAmostra(null); // amostra = null => deseleciona amostra atual
					pontos[nPontos][0] = (double) e.getX();
					pontos[nPontos][1] = (double) e.getY();
					if(nPontos == 2){
						double[] vecTmp = calculaRaio();
						Amostra aM = new Amostra(vecTmp[0], vecTmp[1], vecTmp[2], amostraPontos);
						vetorAmostras.addElement(aM);
						selecionaAmostra(aM);
						nPontos = 0;			
					} else
							nPontos++;
				}
			} else {
				pontos[nPontos][0] = (double) e.getX();
				pontos[nPontos][1] = (double) e.getY();
				if(nPontos == 2){
					double[] vecTmp = calculaRaio();
					Amostra aM = new Amostra(vecTmp[0], vecTmp[1], vecTmp[2], amostraPontos);		
					vetorAmostras.addElement(aM);
					selecionaAmostra(aM);
					nPontos = 0;			
				} else
						nPontos++;
			}
		}
  }

	public void adicionaAmostra(double diam){
		diamAmostra = diam;
		flagUsaDiametro = true;
	}
		
  public void mouseReleased(MouseEvent e) { }

	public void mouseWheelMoved(MouseWheelEvent e) { }

	public void moveAmostra(int dx, int dy){
		if(amostraSelecionada != null){
      amostraSelecionada.move(dx, dy);
			repaint();
    }
	}

	private void selecionaAmostra(Amostra amostra){
		if(amostra == null){
			if(amostraSelecionada != null){		
				amostraSelecionada.atribuiCorBorda(Color.blue);
				amostraSelecionada = amostra;
				indiceAmostra = -1;
			}
		}else{
			int indRow = vetorAmostras.indexOf(amostra);
			if(amostraSelecionada != null){
				amostraSelecionada.atribuiCorBorda(Color.blue);
			}
			amostraSelecionada = amostra;
			indiceAmostra = indRow;
			amostraSelecionada.atribuiCorBorda(Color.red);
		}
		repaint();
  }

	// Verifica a existncia de uma amostra na regio do ponto xc, yc
  // retorna a amostra caso verdadeiro e null caso o ponto no fique dentro
  // de nenhuma amostra
  private Amostra retornaAmostra(int xc, int yc){
    GeneralPath gp;
    Amostra amostra;
    Amostra amostraRet = null;
    int n = vetorAmostras.size();
    for (int ind = 0; ind < n; ind++) {
      amostra = (Amostra) vetorAmostras.get(ind);
      gp = amostra.amostraGP;
      if (gp.contains((double)xc, (double)yc))	{
				amostraRet = amostra;
        break;
      }
    }
    return amostraRet;
  }

	// Calcula trs pontos para desenhar um crculo e as coordenadas do centro
	private double[] calculaRaio(){
		double x1, x2, x3, y1, y2, y3, f, g, m;
		double c, d, e, h, k, s, r;
		double[] ret = new double[3];
		x1 = pontos[0][0];
		y1 = pontos[0][1];
		x2 = pontos[1][0];
		y2 = pontos[1][1];
		x3 = pontos[2][0];
		y3 = pontos[2][1];
		f = x3*x3-x3*x2-x1*x3+x1*x2+y3*y3-y3*y2-y1*y3+y1*y2; //frmula
		g = x3*y1-x3*y2+x1*y2-x1*y3+x2*y3-x2*y1;

		if(g == 0.0)
		   m = 0.0;
		else
		   m = (f / g);

		c = (m * y2) - x2 - x1 - (m * y1);	//frmula
		d = (m * x1) - y1 - y2 - (x2 * m);
		e = (x1 * x2) + (y1 * y2) - (m * x1 * y2) + (m * x2 * y1);

		h = (c / 2.0);			//frmula
		k = (d / 2.0);
		s = (((h) * (h)) + ((k) * (k)) - e);
		r = Math.pow(s, 0.5);
		//System.out.println("x0 = "+h+" y0 = "+k+" r = "+r);
		ret[0] = Math.abs(h);
		ret[1] = Math.abs(k);
		ret[2] = r;
		return ret;
	}

	// Retorna mscara da amostra selecionada
	public int[][] retornaMascara(){
		int[][] ret = null;
		if(amostraSelecionada != null)
            ret = amostraSelecionada.amostraMascara;
		return ret;
	}

	public int[][][] recortaAmostra(){
		int xmin, xmax,	ymin, ymax, largura, altura;
    int lin, col, pix, borda;
    int[][][] pixels = null;
    int[][] maskImg = null;
    int[][] linPlanta = null;
		int nBandas;
    double[][] coordenadasPlantas = null;
		BufferedImage imagemOrig;
		Raster srcR;

		if(amostraSelecionada != null){
			xmin = amostraSelecionada.xMin;
      xmax = amostraSelecionada.xMax;
      ymin = amostraSelecionada.yMin;
      ymax = amostraSelecionada.yMax;
      largura = amostraSelecionada.largura;
      altura =  amostraSelecionada.altura;
      maskImg = amostraSelecionada.amostraMascara;
			imagemOrig = image.retornaBI();
			nBandas = image.retornaBandas();
			pixels = new int[nBandas][largura][altura];
      srcR = imagemOrig.getRaster();
			for (int i = 0; i < altura; i++){
				for (int j = 0; j < largura; j++) {
					for (int nb = 0; nb < nBandas; nb++ ){
						pixels[nb][j][i] = 0;             
					}
				}
      }
                
			lin = 0;
      for (int i = ymin; i < ymax; i++) {
				col = 0;
        for (int j = xmin; j < xmax; j++) {
					if(maskImg[col][lin] > 0) {
						for (int nb = 0; nb < nBandas; nb++ ){
							pix = srcR.getSample(j, i, nb);
							pixels[nb][col][lin] = pix;
						}
					}
					col++;
				}
        lin++;
      }
		}
		return pixels;
	}

	//***************************************************
	//
	//************* Cluster anlise *********************
	//
	//***************************************************
	
	public void calculaKmedias(int nClasses) {

		//	Array para armazenar variveis (bandas) e valores dos pixels:
		//	variavel[largura*altura][#bandas]
		//	linhas = #observaes = #pixels
		//	colunas = #variveis = #bandas
		int variavel[][];

		// Parms usados no algoritmo
    int n1, n2, idr = 0, ip = 0, k = 0;

		int indice, largura, altura, nBandas, npix = 0, n, m, ng;
		int[][] mask, buffer;
		int[] nGrupos;
		Cluster cluster;
		double porcento;
		String[] cores = {"Vermelho", "Verde", "Azul", "Rosa", 
											"Turquesa", "Amarelo", "Violeta"};

		altura = image.retornaAltura();
		largura = image.retornaLargura();
		nBandas = image.retornaBandas();

		// pixels da amostra e valores da mscara (regio circular).
		mask = image.retornaMascara();
		buffer = image.retornaVetorPixels();

		// Define objeto Cluster e l a quantidade de grupos desejados.
		cluster = new Cluster();

		// L as imagens escolhidas e as transforma em vetores-colunas, pois cada
		// banda ser como uma varivel para o clculo dos K-grupos (K-clusters).
		for (int i = 0; i < altura; i++){
			for (int j = 0; j < largura; j++) {
				if(mask[j][i] > 0)
					npix++;
			}
		}
		variavel = new int[npix][nBandas];
		// L as imagens escolhidas e as transforma em vetores-colunas, pois cada
		// banda ser como uma varivel para o clculo dos K-grupos (K-clusters).		
		for (int nb = 0; nb < nBandas; nb++) {
			npix = 0;
			for (int i = 0; i < altura; i++)
				for (int j = 0; j < largura; j++) {
					// Pega pixels da banda k
					indice = i*largura + j;
					if(mask[j][i] > 0){
						variavel[npix][nb] = buffer[nb][indice];
						npix++;
					}
				}
		}		

		// n = #colunas = #variveis
		n = variavel[0].length;
		// m = #linhas = #objetos/observaes
		m = variavel.length;

		// Seqncia para algoritmo KMeans
		// vetor com parties
		grupos = new int[m];

		// faz primeiro cluster = n1
		n1 = n2 = nClasses;
		numeroCluster = n1;

		for (int nc = n1; nc <= n2; nc++) {		// do 13
			/*
			 ip = 0 => a partio inicial em grupos(i) no foi fornecida.
								 Cria partio padro de acordo com Spath (1982), pg. 67,
								 equao 3.2.10.
			*/
		
			if (ip == 0) {
				k = 0;
				for (int i = 0; i < m; i++) {		// do 8
					k++;
          if (k > nc)
						k = k - nc;
          grupos[i] = k;
				}		// 8
			}	// if

			grupos = cluster.kMeans(variavel, grupos, nc, idr);
		}		// 13

		// Cria imagem com parties
		// Gera um nmero aleatrio para gravar imagem .png e arquivo .csv
		// Inicializa o gerador de nmeros aleatrios
		criaImagemCluster(grupos, largura, altura, "kMed");

		System.out.println("calculaKmedias::nomeArquivo: " + nomeArquivo);
		
		// Libera rea das imagens
		variavel = null;

		// Contabiliza #pixels por grupo
		ng = nClasses;
		nGrupos = new int[ng];
		for (int i = 0; i < m ; i++)
			nGrupos[grupos[i]-1]++;

		System.out.println("Estatisticas: #pixels/grupo\n");
		for (int i = 1; i <= ng; i++) {
			porcento = nGrupos[i-1]*100/npix;
			System.out.println("Grupo "+ i + " ("+ cores[i-1] + "): " + nGrupos[i-1] + 
													" pixels. (" + porcento + "%)");
		}

		// Grava arquivo .csv
		gravaArquivoCSV(nGrupos, ng, npix, cores, "kMed");

	}		// calculaKmedias


	private void criaImagemCluster(int[] clusters, int w, int h, String algoritmo) {

		int tipo, pixel, indice, npix = 0;
		int[][] mask, buffer, mascaraPlanta;
		String prefixo;

		// pixels da amostra e valores da mscara (regio circular).
		mask = image.retornaMascara();
		buffer = image.retornaVetorPixels();
		mascaraPlanta =  new int[w][h];
		for (int i = 0; i < h; i++){
			for (int j = 0; j < w; j++) {	
				if(mask[j][i] > 0){			
					mascaraPlanta[j][i] = clusters[npix];
					npix++;
				}else
					mascaraPlanta[j][i] = 0;
			}
		}

		tipo = BufferedImage.TYPE_3BYTE_BGR;
		BufferedImage out = new BufferedImage(w, h, tipo); 
    WritableRaster outWR = out.getRaster(); 

		for (int i = 0; i < h; i++) 
			for (int j = 0; j < w; j++) {
				if(mascaraPlanta[j][i] > 0){		
					pixel = mascaraPlanta[j][i];
					indice = j + i*w;
					switch (pixel) {
						case 1:	// Vermelho
							outWR.setSample(j, i, 0, 255);
							outWR.setSample(j, i, 1, 0);
							outWR.setSample(j, i, 2, 0);
							break;
						case 2:	// Verde
							outWR.setSample(j, i, 0, 0);
							outWR.setSample(j, i, 1, 255);
							outWR.setSample(j, i, 2, 0);
							break;
						case 3:	// Azul
							outWR.setSample(j, i, 0, 0);
							outWR.setSample(j, i, 1, 0);
							outWR.setSample(j, i, 2, 255);
							break;
						case 4:	// Rosa
							outWR.setSample(j, i, 0, 255);
							outWR.setSample(j, i, 1, 0);
							outWR.setSample(j, i, 2, 255);
							break;
						case 5:	// Turquesa
							outWR.setSample(j, i, 0, 0);
							outWR.setSample(j, i, 1, 255);
							outWR.setSample(j, i, 2, 255);
							break;
						case 6:	// Amarelo
							outWR.setSample(j, i, 0, 255);
							outWR.setSample(j, i, 1, 255);
							outWR.setSample(j, i, 2, 0);
							break;
						case 7:	// Violeta
							outWR.setSample(j, i, 0, 128);
							outWR.setSample(j, i, 1, 0);
							outWR.setSample(j, i, 2, 255);
							break;
					}		// switch
				}		// if
			}		// for j

		// Salva a imagem no formato "png", que preserva os valores exatos acima.
		// O formato "jpg" acrescenta efeitos esprios s cores (valores) acima
		// definidas. 
		try	{
			// Recupera o nome da imagem, sem extenso
			String search = ".";
			int i = nomeArquivo.indexOf(search);
			prefixo = nomeArquivo.substring(0, i);
			prefixo += "_" + String.valueOf(numeroCluster) + algoritmo;
			System.out.println("\nCriando arquivo imagem '" + prefixo 
													+ ".png' em ..\\temp\\" + "\n");
			javax.imageio.ImageIO.write(out, "png", 
						new File("..\\temp\\" + prefixo + ".png"));		
		} catch (java.io.IOException e) {
				String msg = "criaImagemCluster::Problema gravando arquivo imgCluster.";
				JOptionPane.showMessageDialog(this, msg);
        System.exit(0);
		}

		// Mostra cluster sobre a imagem recortada
		Graphics2D g2d = imagemOriginal.createGraphics();
		imagemOriginal.setData(outWR);
		AffineTransform atImageSpace = new AffineTransform();
		AlphaComposite myAlpha = AlphaComposite.getInstance(AlphaComposite.SRC_OVER,0.5f);
		g2d.setComposite(myAlpha);
		g2d.drawImage(imagemOriginal, atImageSpace, this);
		repaint();	
	}

public void mostraClusterSelecionado( int[] cl) {

		int tipo, pixel, indice, npix = 0;
		int[][] mask, buffer, mascaraPlanta;
		String prefixo;
		int w = image.retornaLargura();
		int h = image.retornaAltura();
		// pixels da amostra e valores da mscara (regio circular).
		mask = image.retornaMascara();
		buffer = image.retornaVetorPixels();
		mascaraPlanta =  new int[w][h];
		for (int i = 0; i < h; i++){
			for (int j = 0; j < w; j++) {	
				if(mask[j][i] > 0){			
					mascaraPlanta[j][i] = grupos[npix];
					npix++;
				}else
					mascaraPlanta[j][i] = 0;
			}
		}
		WritableRaster destWR = imagemBuckUp.copyData(null); 
		BufferedImage out = new BufferedImage(imagemBuckUp.getColorModel(), destWR, false, null);
		WritableRaster outWR = out.getRaster(); 

		for (int i = 0; i < h; i++) 
			for (int j = 0; j < w; j++) {
				if(mascaraPlanta[j][i] > 0){		
					pixel = mascaraPlanta[j][i];
					indice = j + i*w;
					for(int c = 0; c < 7; c++){
						if(cl[c] == 1){
							if(pixel == c + 1){
								switch (pixel) {
									case 1:	// Vermelho
										outWR.setSample(j, i, 0, 255);
										outWR.setSample(j, i, 1, 0);
										outWR.setSample(j, i, 2, 0);
										break;
									case 2:	// Verde
										outWR.setSample(j, i, 0, 0);
										outWR.setSample(j, i, 1, 255);
										outWR.setSample(j, i, 2, 0);
										break;
									case 3:	// Azul
										outWR.setSample(j, i, 0, 0);
										outWR.setSample(j, i, 1, 0);
										outWR.setSample(j, i, 2, 255);
										break;
									case 4:	// Rosa
										outWR.setSample(j, i, 0, 255);
										outWR.setSample(j, i, 1, 0);
										outWR.setSample(j, i, 2, 255);
										break;
									case 5:	// Turquesa
										outWR.setSample(j, i, 0, 0);
										outWR.setSample(j, i, 1, 255);
										outWR.setSample(j, i, 2, 255);
										break;
									case 6:	// Amarelo
										outWR.setSample(j, i, 0, 255);
										outWR.setSample(j, i, 1, 255);
										outWR.setSample(j, i, 2, 0);
										break;
									case 7:	// Violeta
										outWR.setSample(j, i, 0, 128);
										outWR.setSample(j, i, 1, 0);
										outWR.setSample(j, i, 2, 255);
										break;
								}		// switch
							}
						}
					}
				}		// if
			}		// for j


		// Mostra cluster sobre a imagem recortada
		Graphics2D g2d = imagemOriginal.createGraphics();
		imagemOriginal.setData(outWR);
		AffineTransform atImageSpace = new AffineTransform();
		AlphaComposite myAlpha = AlphaComposite.getInstance(AlphaComposite.SRC_OVER,0.5f);
		g2d.setComposite(myAlpha);
		g2d.drawImage(imagemOriginal, atImageSpace, this);
		repaint();	
	}

	private void gravaArquivoCSV(int[] grupos, int ng, int totalPixels, 
															 String[] cores, String algoritmo) {

		double porcento;
		String prefixo, ln, pV = ";", grupo, cor, pixels, percent, arquivoCSV;
		FileWriter writer;
		BufferedWriter buf_writer;

		// Recupera o nome da imagem, sem extenso
		String search = ".";
		int ind = nomeArquivo.indexOf(search);
		prefixo = nomeArquivo.substring(0, ind);
		arquivoCSV = "..\\temp\\" + prefixo + "_" + String.valueOf(ng)
								 + algoritmo + ".csv";
		try {
			writer = new FileWriter(arquivoCSV);
			buf_writer = new BufferedWriter(writer);
			for (int i = 1; i <= ng; i++) {
				ln = "";
				porcento = grupos[i-1]*100/(totalPixels);
				grupo = "Grupo "+ String.valueOf(i);
				cor = cores[i-1];
				pixels = String.valueOf(grupos[i-1]);
				percent = String.valueOf(porcento);
				ln = grupo + pV + cor + pV + pixels + pV + percent;
				grava_linha(ln, buf_writer);
			}
			buf_writer.close();
			System.out.println("\nCriando arquivo: " + arquivoCSV + "\n");
		} catch (IOException e) {
					String msg = "ImagemPainel::Erro na gravao do arquivo " + arquivoCSV;
					JOptionPane.showMessageDialog(this, msg);
					System.exit(0);
		}
	}

	private void grava_linha(String texto, BufferedWriter buf_writer) {
		try	{
			buf_writer.write(texto);
			buf_writer.newLine();		
		} catch (IOException e) {
			String str = "ImagemPainel::Erro na gravao da linha " + texto;
			System.out.println(str);
			System.exit(0);
		} 
	}

} // fim da classe
    


