/***********************************************************************************
LiviaGUI.java

Direitos Autorais Reservados (c) 2008 Embrapa Informtica Agropecuria

Este programa  software livre; voc pode redistribu-lo e/ou modific-lo sob os
termos da Licena Pblica Geral GNU conforme publicada pela Free Software
Foundation; tanto a verso 2 da Licena, como (a seu critrio) qualquer verso
posterior.

Este programa  distribudo na expectativa de que seja til, porm, SEM NENHUMA
GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU ADEQUAO A UMA
FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral do GNU para mais detalhes.

Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto com este
programa; se no, escreva para a Free Software Foundation, Inc., no endereo 59
Temple Street, Suite 330, Boston, MA 02111-1307 USA.

**********************************************************************************

Parte integrante do software LIVIA

Descrio:

  LiviaGUI- Principal classe do projeto.
            Responsavel pela construo da interface grfica.
 
Desenvolvido por:

 Embrapa Informtica Agropecuria
 Laboratrio de Processamento de Imagens

Informaes do CVS:
       $Source$:
       $Revision$:
       $Date$:

***********************************************************************************/

package classes;

// Pacotes genricOs
import java.io.File;
import java.util.Vector;
import java.beans.PropertyChangeEvent;

// Pacotes AWT
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.BorderLayout;
import java.awt.LayoutManager;

// ... AWT events
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.ActionEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.MouseMotionListener;

// Pacotes do Swing
import javax.swing.Box;
import javax.swing.JMenu;
import javax.swing.JLabel;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.JMenuBar;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import javax.swing.JViewport;
import javax.swing.JMenuItem;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.JFormattedTextField;
import java.beans.PropertyChangeListener;
import javax.swing.plaf.basic.BasicArrowButton;

public class LiviaGUI extends JFrame implements ActionListener, 
																								MouseListener,
																								MouseMotionListener,
																								PropertyChangeListener {
  private JToolBar toolBar1;
  private JSplitPane splitImagensResultado, splitPane2, split2;
  private JTabbedPane tabbedPaneMapas;
	private JTabbedPane tabbedPaneImagens;
	private JTabbedPane tabbedPaneClassifica;
	private BasicArrowButton moveNoroeste;
  private BasicArrowButton moveNorte;
  private BasicArrowButton moveNordeste;
  private BasicArrowButton moveOeste;
  private BasicArrowButton moveCentro;
  private BasicArrowButton moveLeste;
  private BasicArrowButton moveSudoeste;
  private BasicArrowButton moveSul;
  private BasicArrowButton moveSudeste;
  private BasicArrowButton diminuiDiametro;
  private BasicArrowButton aumentaDiametro;
	private JButton btRecorta;
  private JFormattedTextField gruposTextField;
	private ImagemPainel imagemPainel = null;
	private ImagemPainel imagemPainelClassifica = null;
  private int xmin, xmax, ymin, ymax;   
  private int larguraGUI = 1000;
  private int alturaGUI = 700;
	private PainelControle painelControle2;
	private int nPontos = 20;
	private JScrollPane scrollPainelImage;
    
  /** Construtor do Programa,
   *  inicia algumas variveis e  responsavel por chamar as funes 
	 *	correspondentes para a criao da interface grfica e dos algoritimos 
	 *	de clculos de resultados.
   *
   */
  public LiviaGUI() {
  
		/// Inicializa o nome da janela
    super("LIVIA - Library for Visual Image Analysis");
        
    /// Inicializa o icone da janela
    String folha = "C:\\Miranda\\FerrugemCafe\\src\\icones\\folha_verde.gif";
    setIconImage(Toolkit.getDefaultToolkit().getImage(folha));
        
    /// Inicializa o tamanho da janela atravs das dimenes j estabelecidas
    setSize( new Dimension(larguraGUI, alturaGUI));
      
    // Obtem a resoluco atual da tela do computador. Realiza alguns clculos 
		// para centralizar a tela
    Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
    setLocation((screenSize.width-larguraGUI)/2,((screenSize.height-alturaGUI)/2));
        
    /// Cria ToolBar
    toolBar1 = createtoolBarFerramentas();
        
    Box box = Box.createHorizontalBox();
    box.add(toolBar1);
    //box.add(toolBar2);
        
    /// Cria MenuBar
    setJMenuBar(createMenuBar());
    getContentPane().add(box, BorderLayout.NORTH);
        
    /// cria SplitPanel
    criaJanelasDeTrabalho();
    getContentPane().add(splitImagensResultado);
		
  }
    
  /*******************************************************************************************************
   ********************** Inicio da criao da interface grfica do programa ******************************
   *******************************************************************************************************/
    
  /* Cria a barra de ferramentas
     *      Entrada: Nenhuma
     *      Sada: JToolBar preenchida
  */
  protected JToolBar createtoolBarFerramentas(){
        
		toolBar1 = new JToolBar("Ferramentas");
        
    // Cria e adiciona o boto na barra de ferramentas
    String folder = "C:\\Miranda\\FerrugemCafe\\src\\icones\\folder.png";
    JButton c1 = new JButton("Abrir", new ImageIcon(folder));
    c1.setMargin(new Insets(0, 0, 0, 0));

    // Nome do boto que ser usado na hora de obter o evento ocorrido
    c1.setActionCommand("abrir");
    c1.addActionListener(this);
    toolBar1.add(c1);

		// Cria e adiciona o boto na barra de ferramentas
    String cross = "C:\\Miranda\\FerrugemCafe\\src\\icones\\cross.png";
    JButton c4 = new JButton("Fechar", new ImageIcon(cross));
    c4.setMargin(new Insets(0, 0, 0, 0));

    // Nome do boto que ser usado na hora de obter o evento ocorrido
    c4.setActionCommand("fechar");
    c4.addActionListener(this);
    toolBar1.add(c4);
       
    return toolBar1;
  }

  /* Cria o menubar
     *      Entrada: Nenhuma
     *      Saida: JMenuBar contendo Menus e Itens adicionados
    */
  protected JMenuBar createMenuBar() {
        
		JMenu menu;
    JMenuItem menuItem;
    JMenuBar menuBar = new JMenuBar();
        
    // Cria e Adiciona o menu Arquivo no MenuBar, Atalho ALT A
    menu = new JMenu("Arquivo");
    menu.setMnemonic(KeyEvent.VK_A);
    menuBar.add(menu);
        
    // Define o primeiro item do menu Arquivo, Atalho ALT A
    String folder = "C:\\Miranda\\FerrugemCafe\\src\\icones\\folder.png";
    menuItem = new JMenuItem("Abrir",new ImageIcon(folder));
    menuItem.setMnemonic(KeyEvent.VK_A);
    menuItem.setAccelerator(KeyStroke.getKeyStroke(
                KeyEvent.VK_A, ActionEvent.ALT_MASK));
    menuItem.setActionCommand("abrir");
    menuItem.addActionListener(this);
    menu.add(menuItem);
        
    // Adiciona um separador
    menu.addSeparator();
        
    // Define o segundo item do menu Arquivo, Atalho ALT Q
    String cross = "C:\\Miranda\\FerrugemCafe\\src\\icones\\cross.png";
    menuItem = new JMenuItem("Sair", new ImageIcon(cross));
    menuItem.setMnemonic(KeyEvent.VK_Q);
    menuItem.setAccelerator(KeyStroke.getKeyStroke(
                KeyEvent.VK_Q, ActionEvent.ALT_MASK));
    menuItem.setActionCommand("sair");
    menuItem.addActionListener(this);
    menu.add(menuItem);
        
    // Cria e adiciona o menu Processar no MenuBar, Atalho ALT P
    menu = new JMenu("Processar");
    menu.setMnemonic(KeyEvent.VK_P);
    menuBar.add(menu);
        
    // Define o primeiro item do menu Processar, Atalho ALT M
    menuItem = new JMenuItem("Imagem");
    menuItem.setMnemonic(KeyEvent.VK_M);
    menuItem.setAccelerator(KeyStroke.getKeyStroke(
                KeyEvent.VK_M, ActionEvent.ALT_MASK));
    menuItem.setActionCommand("imagem");
    menuItem.addActionListener(this);
    menuItem.setEnabled(false);
    menu.add(menuItem);
        
    // Define o segundo item do menu Processar, Atalho ALT H
    menuItem = new JMenuItem("Histograma");
    menuItem.setMnemonic(KeyEvent.VK_H);
    menuItem.setAccelerator(KeyStroke.getKeyStroke(
                KeyEvent.VK_H, ActionEvent.ALT_MASK));
    menuItem.setActionCommand("histograma");
    menuItem.addActionListener(this);
    menuItem.setEnabled(false);
    menu.add(menuItem);
        
    // Define o terceiro item do menu Processar, Atalho ALT R
    String tick = "C:\\Miranda\\FerrugemCafe\\src\\icones\\tick.png";
    menuItem = new JMenuItem("Rotular",new ImageIcon(tick));
    menuItem.setMnemonic(KeyEvent.VK_R);
    menuItem.setAccelerator(KeyStroke.getKeyStroke(
                KeyEvent.VK_R, ActionEvent.ALT_MASK));
    menuItem.setActionCommand("rotular");
    menuItem.addActionListener(this);
    menuItem.setEnabled(false);
    menu.add(menuItem);
        
    // Adiciona um separador
    menu.addSeparator();
        
    // Define o quarto item do menu Processar, Atalho ALT S
    String disk = "C:\\Miranda\\FerrugemCafe\\src\\icones\\disk.png";
    menuItem = new JMenuItem("Salvar Resultados",new ImageIcon(disk));
    menuItem.setMnemonic(KeyEvent.VK_S);
    menuItem.setAccelerator(KeyStroke.getKeyStroke(
                KeyEvent.VK_S, ActionEvent.ALT_MASK));
    menuItem.setActionCommand("salvarResultados");
    menuItem.addActionListener(this);
    menuItem.setEnabled(false);
    menu.add(menuItem);
        
    // Cria e adiciona o menu Ajuda no MenuBar, Atalho ALT J
    menu = new JMenu("Ajuda");
    menu.setMnemonic(KeyEvent.VK_J);
    menuBar.add(menu);
        
    // Define o primeiro item do menu Ajuda, Atalho ALT T
    menuItem = new JMenuItem("Tpicos");
    menuItem.setMnemonic(KeyEvent.VK_T);
    menuItem.setAccelerator(KeyStroke.getKeyStroke(
                KeyEvent.VK_T, ActionEvent.ALT_MASK));
    menuItem.setActionCommand("topicos");
    menuItem.addActionListener(this);
    menuItem.setEnabled(false);
    menu.add(menuItem);
        
    // Adiciona um separador
    menu.addSeparator();
        
    // Define o segundo item do menu Ajuda, Atalho ALT S
    menuItem = new JMenuItem("Sobre Livia");
    menuItem.setMnemonic(KeyEvent.VK_S);
    menuItem.setAccelerator(KeyStroke.getKeyStroke(
                KeyEvent.VK_S, ActionEvent.ALT_MASK));
    menuItem.setActionCommand("sobre");
    menuItem.addActionListener(this);
    menu.add(menuItem);
        
    return menuBar;
  }
    
  /* Cria as janelas de trabalho
   * Entrada: nenhuma
  */
  public void criaJanelasDeTrabalho() {
		JSplitPane splitImagemControle1, splitClassificaControle2;
	  JSplitPane splitImagemClassifica;
		JPanel painelControle1 = painelEditar();
  	painelControle2 = new PainelControle();
		tabbedPaneImagens = new JTabbedPane();
		scrollPainelImage = new JScrollPane();
		tabbedPaneImagens.addTab("Imagem", null , scrollPainelImage);
  	tabbedPaneClassifica = new JTabbedPane();
  	JTabbedPane tabbedPaneResultados = new JTabbedPane();
    tabbedPaneMapas = new JTabbedPane();

    splitImagemControle1 = new  JSplitPane(JSplitPane.VERTICAL_SPLIT, tabbedPaneImagens, painelControle1);
		splitImagemControle1.setOneTouchExpandable(true);
    splitImagemControle1.setDividerLocation(400);
		splitClassificaControle2 = new  JSplitPane(JSplitPane.VERTICAL_SPLIT, tabbedPaneClassifica, painelControle2);
		splitClassificaControle2.setOneTouchExpandable(true);
    splitClassificaControle2.setDividerLocation(400);
		splitImagemClassifica = new  JSplitPane(JSplitPane.HORIZONTAL_SPLIT, splitImagemControle1, splitClassificaControle2);
		splitImagemClassifica.setOneTouchExpandable(true);
    splitImagemClassifica.setDividerLocation(500);
    splitImagensResultado = new JSplitPane(JSplitPane.VERTICAL_SPLIT, splitImagemClassifica, tabbedPaneResultados);
    splitImagensResultado.setOneTouchExpandable(true);
    splitImagensResultado.setDividerLocation(500);        
    Dimension minimumSize = new Dimension(100, 50);
  }
    
  // Cria e adiciona os buttons de movimento do crculo no painel da imagem
  public JPanel painelEditar(){

		JPanel painelCursor = new JPanel(new GridLayout(3,3));
    moveNoroeste = new BasicArrowButton(BasicArrowButton.NORTH_WEST);
    moveNoroeste.addMouseMotionListener(this);
    moveNoroeste.addActionListener(this);
    moveNorte = new BasicArrowButton(BasicArrowButton.NORTH);
    moveNorte.addMouseMotionListener(this);
    moveNorte.addActionListener(this);
    moveNordeste = new BasicArrowButton(BasicArrowButton.NORTH_EAST);
    moveNordeste.addMouseMotionListener(this);
    moveNordeste.addActionListener(this);
    moveOeste = new BasicArrowButton(BasicArrowButton.WEST);
    moveOeste.addMouseMotionListener(this);
    moveOeste.addActionListener(this);
    moveCentro = new BasicArrowButton(BasicArrowButton.CENTER);
    moveCentro.addMouseMotionListener(this);
    moveCentro.addActionListener(this);
    moveLeste = new BasicArrowButton(BasicArrowButton.EAST);
    moveLeste.addMouseMotionListener(this);
    moveLeste.addActionListener(this);
    moveSudoeste = new BasicArrowButton(BasicArrowButton.SOUTH_WEST);
    moveSudoeste.addMouseMotionListener(this);
    moveSudoeste.addActionListener(this);
    moveSul = new BasicArrowButton(BasicArrowButton.SOUTH);
    moveSul.addMouseMotionListener(this);
    moveSul.addActionListener(this);
    moveSudeste = new BasicArrowButton(BasicArrowButton.SOUTH_EAST);
    moveSudeste.addMouseMotionListener(this);
    moveSudeste.addActionListener(this);
        
    painelCursor.setBorder(new TitledBorder("Mover:"));
    painelCursor.add(moveNoroeste);
    painelCursor.add(moveNorte);
    painelCursor.add(moveNordeste);
    painelCursor.add(moveOeste);
    painelCursor.add(moveCentro);
    painelCursor.add(moveLeste);
    painelCursor.add(moveSudoeste);
    painelCursor.add(moveSul);
    painelCursor.add(moveSudeste);
        
    //-----------------------------------------------------
    // Cria e adiciona os buttons no painel painelButtons
    //-----------------------------------------------------
        
    JPanel painelButtons = new JPanel(new GridLayout(3, 0, 2, 2));
    painelButtons.setBorder(new TitledBorder("Comando:"));
        
		btRecorta = new JButton("Recortar");
		btRecorta.addActionListener(this);
		painelButtons.add(btRecorta);
    JPanel	controlesPane = new JPanel(new GridLayout(0,3));
		controlesPane.add(painelCursor);
		controlesPane.add(painelButtons);
    return controlesPane;
	}

  // Cria GUI e mostra.
  private static void createAndShowGUI() {

		// Decorao da janela
    JFrame.setDefaultLookAndFeelDecorated(true);
    // Cria e inicializa a janela
    LiviaGUI frame = new LiviaGUI();
        
    frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    frame.setVisible(true);
  }
    
	public static void main(String[] args) {
		javax.swing.SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				createAndShowGUI();
      }
    });
	}

  /*******************************************************************************************************
   ********************** Final da criao da interface grfica do programa *******************************
   *******************************************************************************************************/
    
  protected void quit() {
		System.gc();
    System.exit(0);
  }
   
	private void criaAmostra(int[][][] imgPixels,  int[][] mask) {
		JScrollPane scrollPainel = new JScrollPane();
		Imagem img = new Imagem(imgPixels);
		img.atribuiMascara(mask);
		if (imagemPainelClassifica == null){
			imagemPainelClassifica = new ImagemPainel(img, 100.0, 20);	
			tabbedPaneClassifica.addTab("Amostra", null , scrollPainel);	     
			scrollPainel.setViewportView(imagemPainelClassifica);
			scrollPainel.setAutoscrolls(true);
			painelControle2.atribuiPainelDeImagem(imagemPainelClassifica);
		} else {
  		imagemPainelClassifica.atribuiImagem(img, 100.0, 20);
	  	tabbedPaneClassifica.updateUI();
		}
	}
    
  /* Implementao dos eventos ocorridos na interface grfica
   * Entrada: Evento de Ao
   */
  public void actionPerformed(ActionEvent e) {
        
		if ("abrir".equals(e.getActionCommand())) {
			if (imagemPainel == null) {
				Imagem img = new Imagem();
        if (img.retornaNomeArquivoImagem() != null) {
          imagemPainel = new ImagemPainel(img, 100.0, 20);	
          scrollPainelImage.setViewportView(imagemPainel);
          scrollPainelImage.setAutoscrolls(true);
        } else
   				JOptionPane.showMessageDialog(this, "Abrir arquivo imagem!");
			} else {
				imagemPainel.limpa();
				imagemPainel = null;
				Imagem img = new Imagem();
        if (img.retornaNomeArquivoImagem() != null) {
          imagemPainel = new ImagemPainel(img, 100.0, 20);	
          scrollPainelImage.setViewportView(imagemPainel);
          scrollPainelImage.setAutoscrolls(true);
        } else
   				JOptionPane.showMessageDialog(this, "Abrir arquivo imagem!");
			}
    } else if ("sair".equals(e.getActionCommand())) {
        quit();
    } else if("sobre".equals(e.getActionCommand())) {
			janelaSobre();
		} else if ("fechar".equals(e.getActionCommand())) {
          if (tabbedPaneMapas.getComponentCount() == 0)
						quit();
        } else if (e.getSource().equals(moveNoroeste)) {
			      imagemPainel.moveAmostra(-1 , -1);
        } else if (e.getSource().equals(moveNorte)) {
            imagemPainel.moveAmostra(0 , -1);
        } else if (e.getSource().equals(moveNordeste)) {
            imagemPainel.moveAmostra(1 , -1);
        } else if (e.getSource().equals(moveOeste)) {
            imagemPainel.moveAmostra(-1 , 0);
        } else if (e.getSource().equals(moveLeste)) {
            imagemPainel.moveAmostra(1 , 0);
        } else if (e.getSource().equals(moveSudoeste)) {
            imagemPainel.moveAmostra(-1 , 1);
        } else if (e.getSource().equals(moveSul)) {
            imagemPainel.moveAmostra(0 , 1);
        } else if (e.getSource().equals(moveSudeste)) {
            imagemPainel.moveAmostra(1 , 1);
        } else if (e.getSource().equals(aumentaDiametro)) {
						nPontos++;
						gruposTextField.setValue(new Integer(nPontos));
        } else if (e.getSource().equals(diminuiDiametro)) {
					if (nPontos > 1) {
						nPontos--;
						gruposTextField.setValue(new Integer(nPontos));
					}
        } else if (e.getSource().equals(btRecorta)) {
    				int[][][] imgPixels = imagemPainel.recortaAmostra();
						if (imgPixels != null) {
							int[][] mask = imagemPainel.retornaMascara();
							criaAmostra(imgPixels, mask);
						}
        } 
  }

	public void janelaSobre() {

		LayoutManager layout = new GridLayout(5, 1);
    JLabel label1, label2, label3, label4, label5;
		JFrame sobre;

		label1 = new JLabel ("  LIVIA - Library for Visual Image Analysis");
    label2 = new JLabel ("  Embrapa Informtica Agropecuria", JLabel.LEFT);
    label3 = new JLabel ("  Laboratrio de Processamento de Imagens", JLabel.LEFT);
    label4 = new JLabel ("  Verso 1.0", JLabel.LEFT);
    label5 = new JLabel ("  Campinas (SP), julho de 2008", JLabel.LEFT);

		sobre = new JFrame("Sobre Livia");
    sobre.setLayout (layout);
    sobre.add(label1);
    sobre.add(label2);
    sobre.add(label3);
    sobre.add(label4);
    sobre.add(label5);
    sobre.setSize(300, 200);
    sobre.setVisible(true);
	}

	// Mtodos da interface MouseListener e MouseMotionListener
  public void mouseWheelMoved(MouseWheelEvent e) { }
  public void mouseClicked(MouseEvent e) { }
  public void mousePressed(MouseEvent e) {  }
  public void mouseReleased(MouseEvent e) {  }
  public void mouseEntered(MouseEvent e) {  }
  public void mouseExited(MouseEvent e) {  }
	public void mouseMoved(MouseEvent e) {  }
	public void mouseDragged(MouseEvent e) { }

	public void propertyChange(PropertyChangeEvent e) {
		int diam;
    Object source = e.getSource();
    if (source == gruposTextField) {
			diam = ((Number)gruposTextField.getValue()).intValue();
    }
  }
    
}
