/***********************************************************************************
PainelControle.java

Direitos Autorais Reservados (c) 2008 Embrapa Informtica Agropecuria

Este programa  software livre; voc pode redistribu-lo e/ou modific-lo sob os
termos da Licena Pblica Geral GNU conforme publicada pela Free Software
Foundation; tanto a verso 2 da Licena, como (a seu critrio) qualquer verso
posterior.

Este programa  distribudo na expectativa de que seja til, porm, SEM NENHUMA
GARANTIA; nem mesmo a garantia implcita de COMERCIABILIDADE OU ADEQUAO A UMA
FINALIDADE ESPECFICA. Consulte a Licena Pblica Geral do GNU para mais detalhes.

Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU junto com este
programa; se no, escreva para a Free Software Foundation, Inc., no endereo 59
Temple Street, Suite 330, Boston, MA 02111-1307 USA.

**********************************************************************************

Parte integrante do software LIVIA

Descrio:

  Classe para manipular imagens.

Desenvolvido por:

 Embrapa Informtica Agropecuria
 Laboratrio de Processamento de Imagens

Informaes do CVS:
       $Source$:
       $Revision$:
       $Date$:

***********************************************************************************/

package classes;

// Pacotes genricos
import java.util.Vector;
import java.util.Enumeration;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

// Pacotes AWT
import java.awt.Image;
import java.awt.Color;
import java.awt.Point;
import java.awt.Graphics;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.image.Raster;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;

// ... AWT events
import java.awt.event.KeyEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseListener;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.MouseMotionListener;

// Pacotes Swing
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JLabel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.ImageIcon;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.JRadioButton;
import javax.swing.SwingConstants;
import javax.swing.AbstractButton;
import javax.swing.border.TitledBorder;
import javax.swing.JFormattedTextField;
import javax.swing.plaf.basic.BasicArrowButton;

public class PainelControle extends JPanel implements ActionListener, 
								PropertyChangeListener {

	// ATRIBUTOS
	private BasicArrowButton moveNoroeste;
  private BasicArrowButton moveNorte;
  private BasicArrowButton moveNordeste;
  private BasicArrowButton moveOeste;
  private BasicArrowButton moveCentro;
  private BasicArrowButton moveLeste;
  private BasicArrowButton moveSudoeste;
  private BasicArrowButton moveSul;
  private BasicArrowButton moveSudeste;
  private BasicArrowButton diminuiGrupos;
  private BasicArrowButton aumentaGrupos;
	private JButton btClassifica;
  private JFormattedTextField gruposTextField;
	private ImagemPainel imagemPainel;
	private ButtonGroup groupRadio;
	private JPanel painelCursor;
	private int nGrupos = 4;
	private int maxGrupos = 7;
	private int minGrupos = 4;
	private String[] cores = {"Vermelho", "Verde", "Azul", "Rosa",
														"Turquesa", "Amarelo", "Violeta"};	  
  private int[][] corGrupos = {{255,0,0},{0,255,0},{0,0,255},
															 {255,0,255},{0,255,255},{255,255,0},{128,0,255},
															 {102,45,17},{102,17,85}};
	 
    /**
     * Construtor
     *
     * @param image
     * @param zoomPercentage
     */
  public PainelControle() {

		JPanel painelCorGrupo = new JPanel(new GridLayout(2,1));
		painelCursor = new JPanel(new GridLayout(3,4));
		groupRadio = new ButtonGroup();
		criaRadioBottons();
		painelCursor.setBorder(new TitledBorder(" Ferrugem: "));

    // Altera nmero de grupos
    JPanel painelGrupos = new JPanel(new FlowLayout(FlowLayout.CENTER));      
    gruposTextField = new JFormattedTextField(50);
    gruposTextField.setValue(new Integer(nGrupos));
    gruposTextField.setColumns(2);
    gruposTextField.addPropertyChangeListener("value", this);
    gruposTextField.setEditable(false);
        
    JLabel label = new JLabel("Grupos: ");
    btClassifica = new JButton("Classificar");
		btClassifica.addActionListener(this);
    diminuiGrupos = new BasicArrowButton(BasicArrowButton.WEST);
    diminuiGrupos.addActionListener(this);        
    aumentaGrupos = new BasicArrowButton(BasicArrowButton.EAST);
    aumentaGrupos.addActionListener(this);
    painelGrupos.add(label);
    painelGrupos.add(diminuiGrupos);
    painelGrupos.add(gruposTextField);
    painelGrupos.add(aumentaGrupos);
		painelGrupos.add(btClassifica);
    painelGrupos.setBorder(new TitledBorder(" Identificao: "));

		this.setLayout(new GridLayout(0,2));
		this.add(painelGrupos); 
    this.add(painelCursor);
  }

	public void atribuiPainelDeImagem(ImagemPainel painel){
		imagemPainel = painel;
	}

  public void actionPerformed(ActionEvent e) {       
		if (e.getSource().equals(moveNoroeste)) {
			imagemPainel.moveAmostra(-1 , -1);
    } else if (e.getSource().equals(moveNorte)) {
      imagemPainel.moveAmostra(0 , -1);
    } else if (e.getSource().equals(moveNordeste)) {
      imagemPainel.moveAmostra(1 , -1);
    } else if (e.getSource().equals(moveOeste)) {
      imagemPainel.moveAmostra(-1 , 0);
    } else if (e.getSource().equals(moveLeste)) {
      imagemPainel.moveAmostra(1 , 0);
    } else if (e.getSource().equals(moveSudoeste)) {
      imagemPainel.moveAmostra(-1 , 1);
    } else if (e.getSource().equals(moveSul)) {
      imagemPainel.moveAmostra(0 , 1);
    } else if (e.getSource().equals(moveSudeste)) {
      imagemPainel.moveAmostra(1 , 1);
    } else if (e.getSource().equals(aumentaGrupos)) {
      if (nGrupos < maxGrupos) {
				nGrupos++;
				gruposTextField.setValue(new Integer(nGrupos));
			}
    } else if (e.getSource().equals(diminuiGrupos)) {
      if (nGrupos > minGrupos) {
				nGrupos--;
				gruposTextField.setValue(new Integer(nGrupos));
			}
    } else if (e.getSource().equals(btClassifica)) {
				imagemPainel.calculaKmedias(nGrupos);
    } 
	}

	public void propertyChange(PropertyChangeEvent e) {
    int diam;
    Object source = e.getSource();
    if (source == gruposTextField) {
        diam = ((Number)gruposTextField.getValue()).intValue();
        //System.out.println("Grupos = " + diam);
    }
	}

	public void criaRadioBottons(){
		int r, g, b;
		JCheckBox aRadioButton;
		ItemListener ilisten = new GrupoItemListener();
		for (int i = 0; i < maxGrupos; i++) {
			r = corGrupos[i][0];
			g = corGrupos[i][1];
			b = corGrupos[i][2];
			aRadioButton = new JCheckBox(cores[i]);
			aRadioButton.addItemListener(ilisten);  
			painelCursor.add(aRadioButton);
		}
	}

	public class GrupoItemListener2 implements ItemListener {
    public void itemStateChanged(ItemEvent ev) {
      boolean selected = (ev.getStateChange() == ItemEvent.SELECTED);
      AbstractButton button = (AbstractButton) ev.getItemSelectable();
			int i = retornaBotomSelecionado();
			if (i >= 0) {
				int r = corGrupos[i][0];
				int g = corGrupos[i][1];
				int b = corGrupos[i][2];
			}
    }
  }

	public class GrupoItemListener implements ItemListener {
		public void itemStateChanged(ItemEvent ev) {
		  int[] vec = new int[7];
			Component[] components = painelCursor.getComponents();
			for (int k = 0; k < components.length; k++)	{
				JCheckBox cb = (JCheckBox)components[k];
				if (cb.isSelected())	{
					vec[k] = 1;
				} else
					vec[k] = 0;
			}
			imagemPainel.mostraClusterSelecionado(vec); 
		}
	}

	public int retornaBotomSelecionado(){
		JCheckBox b;
		Enumeration e=groupRadio.getElements(); 
		int ind = 0;
		
		while (e.hasMoreElements()) { 
			b = (JCheckBox)e.nextElement(); 
			if(b.isSelected()){
				return ind;
			}
			ind++;
		}
		return -1;
	}
} // fim da classe
   
						